/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.entity;

import com.google.common.collect.ImmutableList;
import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.Config;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.item.ExpandableItemStackHandler;
import com.landmaster.cargoboats.item.MotorboatUpgradeItemHandler;
import com.landmaster.cargoboats.menu.MotorboatMenu;
import com.landmaster.cargoboats.sound.MotorboatSoundInstance;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import com.landmaster.cargoboats.util.Util;
import com.landmaster.cargoboats.util.WrenchHook;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableDouble;

public class Motorboat
extends Boat
implements IEnergyStorage,
MenuProvider,
HasCustomInventoryScreen {
    public static final long STUCK_TIME_THRESHOLD = 100L;
    public final AnimationState rotorAnimationState = new AnimationState();
    public float rotorSpeed = 0.0f;
    private static final EntityDataAccessor<MotorboatSchedule> MOTORBOAT_SCHEDULE = SynchedEntityData.defineId(Motorboat.class, CargoBoats.MOTORBOAT_SCHEDULE_EDS.get());
    private static final EntityDataAccessor<Boolean> MOTOR_ACTIVE = SynchedEntityData.defineId(Motorboat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> NEXT_STOP_INDEX = SynchedEntityData.defineId(Motorboat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(Motorboat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> CLIENT_MOTORBOAT_SPEED = SynchedEntityData.defineId(Motorboat.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> LAVA_UPGRADE_ACTIVE = SynchedEntityData.defineId(Motorboat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private List<BlockPos> path = ImmutableList.of();
    private int dockTime = 0;
    private boolean automationEnabled = true;
    private ChunkPos lastChunk;
    private final LongSet chunkSet = new LongOpenHashSet();
    public static final int NUM_UPGRADES = 5;
    public final MotorboatUpgradeItemHandler upgradeHandler;
    public final ExpandableItemStackHandler itemHandler;
    public final IItemHandlerModifiable combinedHandler;
    private long pathCheckTimestamp = Long.MIN_VALUE;
    private long stuckTime = 100L;
    private final int baseInvSize;
    public static final int CONTAINER_SLOTS = 4;
    public final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> Motorboat.this.getId();
                case 1 -> {
                    if (Motorboat.this.automationEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> Motorboat.this.itemCapacityMultiplier();
                case 3 -> {
                    if (Motorboat.this.baseInvSize == 0) {
                        yield 0;
                    }
                    yield Math.ceilDiv(Motorboat.this.itemHandler.getSlots(), Motorboat.this.baseInvSize);
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 4;
        }
    };

    public Motorboat(EntityType<? extends Motorboat> entityType, Level level, int invSize) {
        super(entityType, level);
        this.upgradeHandler = new MotorboatUpgradeItemHandler(entityType, 5);
        this.itemHandler = new ExpandableItemStackHandler(invSize);
        this.combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgradeHandler, this.itemHandler});
        this.baseInvSize = invSize;
    }

    public Motorboat(EntityType<? extends Motorboat> entityType, Level level) {
        this(entityType, level, 27);
    }

    public Motorboat(Level level, double x, double y, double z) {
        this(CargoBoats.MOTORBOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public ItemStack getWrenchDrop() {
        ItemStack stack = new ItemStack((ItemLike)this.getDropItem());
        CompoundTag tag = new CompoundTag();
        this.addMotorboatSaveData(tag);
        stack.set(CargoBoats.MOTORBOAT_SAVE_DATA, (Object)tag);
        stack.set(CargoBoats.MOTORBOAT_HAS_DATA, (Object)true);
        return stack;
    }

    public void setAutomationEnabled(boolean newValue) {
        this.automationEnabled = newValue;
        if (!this.automationEnabled) {
            this.resetDockingData(false);
        }
    }

    protected float getSinglePassengerXOffset() {
        return 0.35f;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOTORBOAT_SCHEDULE, (Object)MotorboatSchedule.INITIAL);
        builder.define(MOTOR_ACTIVE, (Object)false);
        builder.define(NEXT_STOP_INDEX, (Object)0);
        builder.define(ENERGY, (Object)0);
        builder.define(CLIENT_MOTORBOAT_SPEED, (Object)Float.valueOf(1.0f));
        builder.define(LAVA_UPGRADE_ACTIVE, (Object)true);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readMotorboatSaveData(compound);
    }

    public void readMotorboatSaveData(CompoundTag compound) {
        this.getEntityData().set(ENERGY, (Object)compound.getInt("EnergyStorage"));
        this.getEntityData().set(MOTORBOAT_SCHEDULE, (Object)((MotorboatSchedule)MotorboatSchedule.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("MotorboatSchedule")).getOrThrow()));
        this.getEntityData().set(NEXT_STOP_INDEX, (Object)compound.getInt("NextStop"));
        this.dockTime = compound.getInt("DockTime");
        this.automationEnabled = compound.getBoolean("AutomationEnabled");
        this.upgradeHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("Upgrades"));
        this.itemHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("Inventory"));
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addMotorboatSaveData(compound);
    }

    public void addMotorboatSaveData(CompoundTag compound) {
        compound.putInt("EnergyStorage", this.getEnergyStored());
        compound.put("MotorboatSchedule", (Tag)MotorboatSchedule.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getMotorboatSchedule()).getOrThrow());
        compound.putInt("NextStop", ((Integer)this.getEntityData().get(NEXT_STOP_INDEX)).intValue());
        compound.putInt("DockTime", this.dockTime);
        compound.putBoolean("AutomationEnabled", this.automationEnabled);
        compound.put("Upgrades", (Tag)this.upgradeHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.put("Inventory", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    public MotorboatSchedule getMotorboatSchedule() {
        return (MotorboatSchedule)this.getEntityData().get(MOTORBOAT_SCHEDULE);
    }

    public boolean lavaUpgradeActive() {
        return (Boolean)this.getEntityData().get(LAVA_UPGRADE_ACTIVE);
    }

    @Nonnull
    public Item getDropItem() {
        return CargoBoats.MOTORBOAT_ITEM.asItem();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        if (player.isSpectator()) {
            return null;
        }
        return new MotorboatMenu(containerId, playerInventory, this);
    }

    public void destroy(@Nonnull Item dropItem) {
        super.destroy(dropItem);
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.dropContents();
        }
    }

    public int energyConsumption() {
        return Config.MOTORBOAT_BASE_ENERGY_USAGE.getAsInt();
    }

    public void remove(@Nonnull Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason == Entity.RemovalReason.KILLED) {
            this.dropContents();
        }
        super.remove(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = this.chunkSet.iterator();
            while (level.hasNext()) {
                long chunkPos = (Long)level.next();
                CargoBoats.TICKET_CONTROLLER.forceChunk(level2, (Entity)this, (int)chunkPos, (int)(chunkPos >> 32), false, false);
            }
        }
    }

    private void dropContents() {
        for (int i = 0; i < this.combinedHandler.getSlots(); ++i) {
            Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)this.combinedHandler.getStackInSlot(i));
        }
    }

    public double motorboatSpeed() {
        return Config.MOTORBOAT_BASE_SPEED.getAsDouble() * this.relativeMotorboatSpeed();
    }

    public double relativeMotorboatSpeed() {
        double res = 1.0;
        int numSpeedUpgrades = Util.countItem((IItemHandler)this.upgradeHandler, (Item)CargoBoats.SPEED_UPGRADE.get());
        if (numSpeedUpgrades > 0) {
            List multipliers = (List)Config.MOTORBOAT_SPEED_MULTIPLIERS.get();
            res *= ((Double)multipliers.get(Math.min(numSpeedUpgrades - 1, multipliers.size()))).doubleValue();
        }
        return res;
    }

    private void chunkLoad() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!this.chunkPosition().equals((Object)this.lastChunk)) {
                LongOpenHashSet newChunkSet = new LongOpenHashSet();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        ChunkPos chunkPos = new ChunkPos(this.chunkPosition().x + i, this.chunkPosition().z + j);
                        newChunkSet.add(chunkPos.toLong());
                        CargoBoats.TICKET_CONTROLLER.forceChunk(level2, (Entity)this, chunkPos.x, chunkPos.z, true, false);
                    }
                }
                if (this.chunkSet.removeAll((LongCollection)newChunkSet)) {
                    LongIterator longIterator = this.chunkSet.iterator();
                    while (longIterator.hasNext()) {
                        long chunkPos = (Long)longIterator.next();
                        CargoBoats.TICKET_CONTROLLER.forceChunk(level2, (Entity)this, (int)chunkPos, (int)(chunkPos >> 32), false, false);
                    }
                }
                this.chunkSet.clear();
                this.chunkSet.addAll((LongCollection)newChunkSet);
                this.lastChunk = this.chunkPosition();
            }
        }
    }

    private void adjustCapacity() {
        this.itemHandler.setSize(this.baseInvSize * this.itemCapacityMultiplier());
    }

    public int itemCapacityMultiplier() {
        int numUpgrades = Util.countItem((IItemHandler)this.upgradeHandler, (Item)CargoBoats.CAPACITY_UPGRADE.get());
        return numUpgrades > 0 ? (Integer)((List)Config.MOTORBOAT_ITEM_CAPACITY_MULTIPLIER.get()).get(numUpgrades - 1) : 1;
    }

    protected void controlManualMotorboat() {
        if (this.isVehicle()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f;
            }
            if (this.inputDown) {
                f -= 0.005f;
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * (f *= ((Float)this.getEntityData().get(CLIENT_MOTORBOAT_SPEED)).floatValue())), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    public void tick() {
        this.chunkLoad();
        this.adjustCapacity();
        if (!this.level().isClientSide && !this.isControlledByLocalInstance()) {
            this.getEntityData().set(CLIENT_MOTORBOAT_SPEED, (Object)Float.valueOf((float)this.relativeMotorboatSpeed()));
        }
        if (!this.level().isClientSide) {
            this.getEntityData().set(LAVA_UPGRADE_ACTIVE, (Object)(Util.countItem((IItemHandler)this.upgradeHandler, (Item)CargoBoats.LAVA_UPGRADE.get()) > 0 ? 1 : 0));
        }
        MutableBoolean motorActive = new MutableBoolean(false);
        MutableDouble expectedSpeed2 = new MutableDouble(0.0);
        MotorboatSchedule motorboatSchedule = this.getMotorboatSchedule();
        int nextStopIdx = (Integer)this.getEntityData().get(NEXT_STOP_INDEX);
        if (!this.rotorAnimationState.isStarted()) {
            this.rotorAnimationState.start(this.tickCount);
        }
        if (!this.level().isClientSide && this.automationEnabled && this.isControlledByLocalInstance()) {
            if (!motorboatSchedule.entries().isEmpty() && this.nextStop().get().dimension() == this.level().dimension()) {
                BlockPos pos = motorboatSchedule.entries().get(nextStopIdx).dock();
                MotorboatPathfindingNode cap = (MotorboatPathfindingNode)this.level().getCapability(CargoBoats.MOTORBOAT_PATHFINDING_NODE, pos);
                if (cap != null) {
                    long gameTime = this.level().getGameTime();
                    if (cap.isMotorboatDocked(this)) {
                        if (this.dockTime >= motorboatSchedule.entries().get(nextStopIdx).stopTime()) {
                            this.getEntityData().set(NEXT_STOP_INDEX, (Object)((nextStopIdx + 1) % motorboatSchedule.entries().size()));
                            this.dockTime = 0;
                            this.stuckTime = 100L;
                            if (cap.doBoatHorn()) {
                                this.playSound(CargoBoats.BOAT_HORN_SOUND.get(), 0.5f, 0.0f);
                            }
                        }
                        this.path = ImmutableList.of();
                        ++this.dockTime;
                    } else if (!(this.pathCheckTimestamp + 30L >= gameTime || this.detectedMotorboats().isEmpty() && this.stuckTime < 100L)) {
                        Pair<BlockPos, BlockPos> pair = cap.getBoxForMotorboatPathfinding();
                        this.path = this.pathfindToDockAABB(this.positionForPathfinding(), (BlockPos)pair.first(), (BlockPos)pair.second());
                        this.pathCheckTimestamp = gameTime;
                    }
                }
            } else {
                this.resetDockingData(false);
            }
        }
        this.oldStatus = this.status;
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Boat.Status.UNDER_WATER && this.status != Boat.Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.level().isClientSide && this.outOfControlTicks >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.baseTick();
        this.tickLerp();
        if (this.isControlledByLocalInstance()) {
            if (!(this.getFirstPassenger() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            this.floatBoat();
            if (this.level().isClientSide) {
                this.controlManualMotorboat();
            }
            if (!this.level().isClientSide && this.automationEnabled) {
                this.targetLocation().ifPresent(vec -> {
                    Vec3 deltaVector = vec.subtract(this.position());
                    int energyConsumption = this.energyConsumption();
                    if (deltaVector.horizontalDistance() < 0.1) {
                        this.path.removeLast();
                    } else if (this.extractEnergy(energyConsumption, true) >= energyConsumption) {
                        this.extractEnergy(energyConsumption, false);
                        motorActive.setTrue();
                        double scalar = Math.min(this.motorboatSpeed() / deltaVector.horizontalDistance(), 0.2);
                        deltaVector = new Vec3(deltaVector.x * scalar, 0.0, deltaVector.z * scalar);
                        this.setYRot((float)(Math.toDegrees(Math.atan2(deltaVector.z, deltaVector.x)) - 90.0));
                        this.setDeltaMovement(deltaVector);
                        expectedSpeed2.setValue(deltaVector.horizontalDistanceSqr());
                    }
                });
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.tickBubbleColumn();
        this.checkInsideBlocks();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, -0.01, 0.2), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this)) continue;
                if (flag && this.getPassengers().size() < this.getMaxPassengers() && !entity.isPassenger() && this.hasEnoughSpaceFor(entity) && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.startRiding((Entity)this);
                    continue;
                }
                this.push(entity);
            }
        }
        if (!this.level().isClientSide) {
            this.getEntityData().set(MOTOR_ACTIVE, (Object)motorActive.booleanValue());
            if (this.automationEnabled && this.isControlledByLocalInstance()) {
                this.stuckTime = this.position().distanceToSqr(this.xo, this.yo, this.zo) < 0.04000000000000001 * expectedSpeed2.getValue() ? ++this.stuckTime : 0L;
            }
        } else {
            this.rotorSpeed = Math.clamp(this.rotorSpeed + ((Boolean)this.getEntityData().get(MOTOR_ACTIVE) != false ? 0.01f : -0.01f), 0.0f, 1.0f);
        }
    }

    private void resetDockingData(boolean setStopIdx) {
        this.dockTime = 0;
        this.stuckTime = 100L;
        if (setStopIdx) {
            MotorboatSchedule schedule = (MotorboatSchedule)this.getEntityData().get(MOTORBOAT_SCHEDULE);
            int candMinDockIndex = 0;
            for (int i = 0; i < schedule.entries().size(); ++i) {
                MotorboatSchedule.Entry entry = schedule.entries().get(i);
                if (entry.dimension() != this.level().dimension() || !(entry.dock().distToCenterSqr((Position)this.position()) < schedule.entries().get(candMinDockIndex).dock().distToCenterSqr((Position)this.position()))) continue;
                candMinDockIndex = i;
            }
            this.getEntityData().set(NEXT_STOP_INDEX, (Object)candMinDockIndex);
        }
        this.path = ImmutableList.of();
    }

    @Nonnull
    public InteractionResult interact(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult interactionresult;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(WrenchHook.WRENCH_TAG) && player.isSecondaryUseActive()) {
            ItemStack wrenchDrop = this.getWrenchDrop();
            PlayerMainInvWrapper invWrapper = new PlayerMainInvWrapper(player.getInventory());
            if (ItemHandlerHelper.insertItem((IItemHandler)invWrapper, (ItemStack)wrenchDrop, (boolean)true).isEmpty()) {
                ItemHandlerHelper.insertItem((IItemHandler)invWrapper, (ItemStack)wrenchDrop, (boolean)false);
                this.discard();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (stack.has(CargoBoats.MOTORBOAT_SCHEDULE)) {
            MotorboatSchedule schedule = (MotorboatSchedule)stack.get(CargoBoats.MOTORBOAT_SCHEDULE);
            this.getEntityData().set(MOTORBOAT_SCHEDULE, (Object)schedule);
            this.resetDockingData(true);
            if (this.level().isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.cargoboats.motorboat_programmed"), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.is(CargoBoats.MOTORBOAT_TRACKER)) {
            stack.set(CargoBoats.TRACKED_MOTORBOAT, (Object)this.uuid);
            if (this.level().isClientSide) {
                player.displayClientMessage((Component)Component.translatable((String)"message.cargoboats.motorboat_tracked", (Object[])new Object[]{this.uuid.toString()}), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isSecondaryUseActive() && (interactionresult = super.interact(player, hand)) != InteractionResult.PASS) {
            return interactionresult;
        }
        if (this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        OptionalInt openMenuResult = player.openMenu((MenuProvider)this);
        if (openMenuResult.isPresent()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
        }
        return openMenuResult.isPresent() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void openCustomInventoryScreen(Player player) {
        OptionalInt openMenuResult = player.openMenu((MenuProvider)this);
        if (openMenuResult.isPresent() && !this.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
        }
    }

    public void onAddedToLevel() {
        if (this.level().isClientSide) {
            new PlayMotorboatSound().run();
        }
    }

    public int receiveEnergy(int i, boolean b) {
        int energy = this.getEnergyStored();
        int toReceive = Math.clamp((long)i, 0, this.getMaxEnergyStored() - energy);
        if (!b) {
            this.getEntityData().set(ENERGY, (Object)(energy + toReceive));
        }
        return toReceive;
    }

    public int extractEnergy(int i, boolean b) {
        int energy = this.getEnergyStored();
        int toExtract = Math.clamp((long)i, 0, energy);
        if (!b) {
            this.getEntityData().set(ENERGY, (Object)(energy - toExtract));
        }
        return toExtract;
    }

    public int getEnergyStored() {
        return (Integer)this.getEntityData().get(ENERGY);
    }

    public int getMaxEnergyStored() {
        return Config.MOTORBOAT_BASE_ENERGY_CAPACITY.getAsInt();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean fireImmune() {
        return this.lavaUpgradeActive() || super.fireImmune();
    }

    private double calcHeuristic(BlockPos point, BlockPos minGoal, BlockPos maxGoal) {
        double cand = Double.POSITIVE_INFINITY;
        for (int x = minGoal.getX(); x <= maxGoal.getX(); ++x) {
            for (int z = minGoal.getZ(); z <= maxGoal.getZ(); ++z) {
                cand = Math.min(cand, point.distSqr((Vec3i)new BlockPos(x, point.getY(), z)));
            }
        }
        return 1.5 * Math.sqrt(cand);
    }

    private boolean posValid(BlockPos pos) {
        if (!this.canBoatInFluid(this.level().getFluidState(pos))) {
            return false;
        }
        BlockState curState = this.level().getBlockState(pos);
        if (!curState.getCollisionShape((BlockGetter)this.level(), pos).isEmpty() || curState.getBlock() instanceof BubbleColumnBlock && curState.getOptionalValue((Property)BubbleColumnBlock.DRAG_DOWN).orElse(false).booleanValue()) {
            return false;
        }
        BlockState aboveState = this.level().getBlockState(pos.above());
        return aboveState.getCollisionShape((BlockGetter)this.level(), pos.above()).isEmpty();
    }

    private boolean nodeValid(BlockPos point, Long2BooleanMap cache) {
        return cache.computeIfAbsent(point.asLong(), p -> BlockPos.betweenClosedStream((BlockPos)new BlockPos(point.getX() - 1, point.getY(), point.getZ() - 1), (BlockPos)new BlockPos(point.getX() + 1, point.getY(), point.getZ() + 1)).allMatch(this::posValid));
    }

    private List<BlockPos> getNeighbors(BlockPos point, Long2BooleanMap cache) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(4);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos cand = point.relative(direction);
            if (!this.nodeValid(cand, cache)) continue;
            result.add(cand);
        }
        return result;
    }

    private boolean hasLOS(BlockPos pointA, BlockPos pointB, Long2BooleanMap cache) {
        int deltaX = Math.abs(pointB.getX() - pointA.getX());
        int deltaZ = -Math.abs(pointB.getZ() - pointA.getZ());
        int sgnX = pointA.getX() < pointB.getX() ? 1 : -1;
        int sgnZ = pointA.getZ() < pointB.getZ() ? 1 : -1;
        int e = deltaX + deltaZ;
        int x = pointA.getX();
        int z = pointA.getZ();
        while (true) {
            if (!this.nodeValid(new BlockPos(x, pointA.getY(), z), cache)) {
                return false;
            }
            if (x == pointB.getX() && z == pointB.getZ()) break;
            if (2 * e >= deltaZ) {
                if (x == pointB.getX()) break;
                e += deltaZ;
                x += sgnX;
            }
            if (2 * e > deltaX) continue;
            if (z == pointB.getZ()) break;
            e += deltaX;
            z += sgnZ;
        }
        return true;
    }

    private List<Motorboat> detectedMotorboats() {
        BlockPos start = this.positionForPathfinding();
        return this.level().getEntitiesOfClass(Motorboat.class, AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(start.getX() - 4, start.getY(), start.getZ() - 4), (BlockPos)new BlockPos(start.getX() + 4, start.getY(), start.getZ() + 4)));
    }

    private List<BlockPos> pathfindToDockAABB(BlockPos start, BlockPos minGoal, BlockPos maxGoal) {
        if (minGoal.getY() > start.getY() || maxGoal.getY() < start.getY()) {
            return ImmutableList.of();
        }
        Long2BooleanOpenHashMap posCache = new Long2BooleanOpenHashMap();
        Long2DoubleOpenHashMap dists = new Long2DoubleOpenHashMap();
        Long2LongOpenHashMap parents = new Long2LongOpenHashMap();
        ObjectHeapPriorityQueue pq = new ObjectHeapPriorityQueue();
        dists.put(start.asLong(), 0.0);
        pq.enqueue((Object)new PathfindPQEntry(this.calcHeuristic(start, minGoal, maxGoal), start.asLong()));
        for (Motorboat otherMotorboat : this.detectedMotorboats()) {
            if (otherMotorboat == this) continue;
            posCache.put(otherMotorboat.positionForPathfinding().asLong(), false);
        }
        while (!pq.isEmpty()) {
            PathfindPQEntry entry = (PathfindPQEntry)pq.dequeue();
            double maxSearchDist = Config.MOTORBOAT_MAX_SEARCH_DISTANCE.getAsDouble();
            if (entry.cost > maxSearchDist || dists.size() > Mth.floor((double)(maxSearchDist * 16.0))) break;
            BlockPos point = BlockPos.of((long)entry.point);
            if (point.getX() >= minGoal.getX() && point.getX() <= maxGoal.getX() && point.getZ() >= minGoal.getZ() && point.getZ() <= maxGoal.getZ()) {
                ArrayList<BlockPos> result = new ArrayList<BlockPos>();
                long pointLong = entry.point;
                while (true) {
                    result.add(BlockPos.of((long)pointLong));
                    if (!parents.containsKey(pointLong)) break;
                    pointLong = parents.get(pointLong);
                }
                return result;
            }
            for (BlockPos cand : this.getNeighbors(point, (Long2BooleanMap)posCache)) {
                BlockPos parent;
                BlockPos candParent = point;
                if (parents.containsKey(entry.point) && this.hasLOS(parent = BlockPos.of((long)parents.get(entry.point)), cand, (Long2BooleanMap)posCache)) {
                    candParent = parent;
                }
                double candDist = dists.get(candParent.asLong()) + Math.sqrt(candParent.distSqr((Vec3i)cand));
                if (!(dists.getOrDefault(cand.asLong(), Double.POSITIVE_INFINITY) > candDist)) continue;
                dists.put(cand.asLong(), candDist);
                parents.put(cand.asLong(), candParent.asLong());
                pq.enqueue((Object)new PathfindPQEntry(candDist + this.calcHeuristic(cand, minGoal, maxGoal), cand.asLong()));
            }
        }
        return ImmutableList.of();
    }

    private BlockPos positionForPathfinding() {
        return BlockPos.containing((Position)this.position());
    }

    private Optional<Vec3> targetLocation() {
        if (this.path.size() >= 2) {
            BlockPos intVec = this.path.get(this.path.size() - 2);
            return Optional.of(new Vec3((double)intVec.getX() + 0.5, (double)intVec.getY(), (double)intVec.getZ() + 0.5));
        }
        return Optional.empty();
    }

    public int nextStopIndex() {
        return (Integer)this.getEntityData().get(NEXT_STOP_INDEX);
    }

    public Optional<MotorboatSchedule.Entry> nextStop() {
        int idx = this.nextStopIndex();
        List<MotorboatSchedule.Entry> entries = this.getMotorboatSchedule().entries();
        if (idx < 0 || idx >= entries.size()) {
            return Optional.empty();
        }
        return Optional.of(entries.get(idx));
    }

    private class PlayMotorboatSound {
        private final MotorboatSoundInstance soundInstance;

        private PlayMotorboatSound() {
            this.soundInstance = new MotorboatSoundInstance(Motorboat.this);
        }

        public void run() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
        }
    }

    private record PathfindPQEntry(double cost, long point) implements Comparable<PathfindPQEntry>
    {
        @Override
        public int compareTo(@Nonnull PathfindPQEntry o) {
            return Double.compare(this.cost, o.cost);
        }
    }
}

