/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.entity.render;

import com.landmaster.cargoboats.entity.FluidMotorboat;
import com.landmaster.cargoboats.entity.render.MotorboatModel;
import com.landmaster.cargoboats.util.FluidRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidMotorboatRenderer
extends EntityRenderer<FluidMotorboat> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/entity/fluid_motorboat.png"), "main");
    private final MotorboatModel model;

    public FluidMotorboatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MotorboatModel(context.bakeLayer(LAYER_LOCATION));
    }

    public void render(@Nonnull FluidMotorboat p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entityYaw - 90.0f));
        this.model.setupAnim(p_entity, 0.0f, 0.0f, (float)p_entity.tickCount + partialTick, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.model.renderType(LAYER_LOCATION.getModel()));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!p_entity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferSource.getBuffer(RenderType.waterMask());
            this.model.waterPatch().render(poseStack, vertexconsumer1, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.pushPose();
        FluidStack fluidStack = p_entity.tank.getFluid();
        int capacity = p_entity.tank.getCapacity();
        poseStack.translate(-0.56f, -0.25f, 0.37f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(0.73f, 0.73f * Math.clamp((float)fluidStack.getAmount() / (float)capacity, 0.0f, 1.0f), 0.73f);
        FluidRenderUtil.renderCubeUsingQuads(fluidStack, partialTick, poseStack, bufferSource, packedLight, packedLight);
        poseStack.popPose();
        poseStack.popPose();
        super.render((Entity)p_entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull FluidMotorboat motorboat) {
        return LAYER_LOCATION.getModel();
    }
}

