/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.entity.render;

import com.landmaster.cargoboats.entity.Motorboat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class MotorboatModel
extends HierarchicalModel<Motorboat>
implements WaterPatchModel {
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart waterPatch;
    private final ModelPart rotor;

    public MotorboatModel(ModelPart root) {
        this.root = root;
        this.main = root.getChild("main");
        this.waterPatch = root.getChild("waterPatch");
        this.rotor = this.main.getChild("rotor");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, -28.0f, -10.0f, 20.0f, 1.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(42, 36).addBox(-10.0f, -35.0f, -10.0f, 20.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(42, 45).addBox(-10.0f, -35.0f, 9.0f, 20.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-10.0f, -35.0f, -10.0f, 1.0f, 8.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(76, 86).addBox(-8.99f, -40.01f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = main.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(56, 21).addBox(-13.0f, -8.0f, -1.0f, 14.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)19.0f, (float)-27.0f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r2 = main.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(42, 54).addBox(-13.0f, -8.0f, -1.4f, 14.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)18.0f, (float)-27.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r3 = main.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 21).addBox(-14.0f, -1.0f, 0.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.0f, (float)-27.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rotor = main.addOrReplaceChild("rotor", CubeListBuilder.create().texOffs(62, 119).addBox(-2.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(5, 106).addBox(-1.0f, -7.0f, -1.0f, 1.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 107).addBox(-1.0f, -1.0f, -7.0f, 1.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.0f, (float)-31.0f, (float)0.0f));
        PartDefinition waterPatch = partdefinition.addOrReplaceChild("waterPatch", CubeListBuilder.create().texOffs(3, 2).addBox(-9.0f, -34.0f, -9.0f, 19.0f, 7.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)23.0f, (float)0.0f));
        PartDefinition cube_r4 = waterPatch.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 21).addBox(-14.0f, -7.0f, 0.0f, 14.0f, 7.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)20.0f, (float)-27.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.main.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @Nonnull
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(@Nonnull Motorboat motorboat, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        motorboat.rotorAnimationState.updateTime(ageInTicks, motorboat.rotorSpeed);
        this.rotor.xRot = (float)Math.toRadians(motorboat.rotorAnimationState.getAccumulatedTime() * 10L % 360L);
    }

    @Nonnull
    public ModelPart waterPatch() {
        return this.waterPatch;
    }
}

