/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.entity.render;

import com.landmaster.cargoboats.entity.Motorboat;
import com.landmaster.cargoboats.entity.render.MotorboatModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MotorboatRenderer
extends EntityRenderer<Motorboat> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/entity/motorboat.png"), "main");
    private final MotorboatModel model;

    public MotorboatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MotorboatModel(context.bakeLayer(LAYER_LOCATION));
    }

    public void render(@Nonnull Motorboat p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entityYaw - 90.0f));
        this.model.setupAnim(p_entity, 0.0f, 0.0f, (float)p_entity.tickCount + partialTick, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.model.renderType(LAYER_LOCATION.getModel()));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!p_entity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferSource.getBuffer(RenderType.waterMask());
            this.model.waterPatch().render(poseStack, vertexconsumer1, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
        super.render((Entity)p_entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull Motorboat motorboat) {
        return LAYER_LOCATION.getModel();
    }
}

