/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.item;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.Config;
import com.landmaster.cargoboats.item.MotorboatUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class CapacityUpgradeItem
extends Item
implements MotorboatUpgrade {
    public CapacityUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int maxUpgradeAmount(EntityType<?> entityType) {
        if (entityType == CargoBoats.FLUID_MOTORBOAT.get()) {
            return ((List)Config.MOTORBOAT_FLUID_CAPACITY.get()).size();
        }
        return ((List)Config.MOTORBOAT_ITEM_CAPACITY_MULTIPLIER.get()).size();
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        List itemMultipliers = (List)Config.MOTORBOAT_ITEM_CAPACITY_MULTIPLIER.get();
        List fluidCapacities = (List)Config.MOTORBOAT_FLUID_CAPACITY.get();
        for (int i = 0; i < Math.max(itemMultipliers.size(), fluidCapacities.size()); ++i) {
            ArrayList<MutableComponent> subComponents = new ArrayList<MutableComponent>(3);
            subComponents.add(Component.literal((String)Integer.toString(i + 1)));
            if (i < itemMultipliers.size()) {
                subComponents.add(Component.translatable((String)"tooltip.cargoboats.capacity_upgrade.items", (Object[])new Object[]{itemMultipliers.get(i)}));
            }
            if (i < fluidCapacities.size()) {
                subComponents.add(Component.translatable((String)"tooltip.cargoboats.capacity_upgrade.fluids", (Object[])new Object[]{fluidCapacities.get(i)}));
            }
            tooltipComponents.add((Component)Component.translatable((String)("tooltip.cargoboats.capacity_upgrade." + (subComponents.size() - 1)), (Object[])subComponents.toArray()).withStyle(ChatFormatting.AQUA));
        }
    }
}

