/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.item;

import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ExpandableItemStackHandler
extends ItemStackHandler {
    private int actualCapacity;

    public ExpandableItemStackHandler(int initialSlots) {
        super(NonNullList.createWithCapacity((int)initialSlots));
        while (this.stacks.size() < initialSlots) {
            this.stacks.add((Object)ItemStack.EMPTY);
        }
        this.actualCapacity = initialSlots;
    }

    public void setSize(int newCapacity) {
        while (this.stacks.size() < newCapacity) {
            this.stacks.add((Object)ItemStack.EMPTY);
        }
        while (this.stacks.size() > newCapacity && ((ItemStack)this.stacks.getLast()).isEmpty()) {
            this.stacks.removeLast();
        }
        this.actualCapacity = newCapacity;
    }

    public void trim() {
        this.setSize(this.actualCapacity);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot < this.actualCapacity;
    }

    public int getActualCapacity() {
        return this.actualCapacity;
    }

    @Nonnull
    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putInt("ActualCapacity", this.actualCapacity);
        return tag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.actualCapacity = nbt.getInt("ActualCapacity");
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.getSlots()) {
            return ItemStack.EMPTY;
        }
        return super.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= this.actualCapacity) {
            return;
        }
        super.setStackInSlot(slot, stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.actualCapacity) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.getSlots()) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }
}

