/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.item;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.menu.MotorboatProgrammerMenu;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MotorboatProgrammerItem
extends Item {
    public MotorboatProgrammerItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack withSchedule(MotorboatSchedule schedule) {
        ItemStack res = new ItemStack((ItemLike)this);
        res.set(CargoBoats.MOTORBOAT_SCHEDULE, (Object)schedule);
        return res;
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@Nonnull ItemStack stack, @Nonnull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        MotorboatPathfindingNode cap = (MotorboatPathfindingNode)level.getCapability(CargoBoats.MOTORBOAT_PATHFINDING_NODE, pos);
        if (cap != null) {
            MotorboatSchedule prevSchedule = (MotorboatSchedule)stack.get(CargoBoats.MOTORBOAT_SCHEDULE);
            stack.set(CargoBoats.MOTORBOAT_SCHEDULE, (Object)new MotorboatSchedule(Stream.concat(prevSchedule.entries().stream(), Stream.of(new MotorboatSchedule.Entry(pos, cap.defaultStopTime(), (ResourceKey<Level>)level.dimension()))).collect(Collectors.toList())));
            if (level.isClientSide && player != null) {
                MotorboatSchedule.Entry lastEntry;
                player.displayClientMessage((Component)Component.translatable((String)"message.cargoboats.dock_added", (Object[])new Object[]{pos.toShortString()}), false);
                if (!prevSchedule.entries().isEmpty() && (lastEntry = prevSchedule.entries().getLast()).dimension() == level.dimension()) {
                    BlockPos lastPos = prevSchedule.entries().getLast().dock();
                    player.displayClientMessage((Component)Component.translatable((String)"message.cargoboats.dock_added.distance", (Object[])new Object[]{new DecimalFormat("0.0").format(Math.sqrt(lastPos.distSqr((Vec3i)pos)))}), false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        return player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, thePlayer) -> new MotorboatProgrammerMenu(id, stack), stack.getHoverName()), buf -> MotorboatSchedule.STREAM_CODEC.encode(buf, (Object)((MotorboatSchedule)stack.get(CargoBoats.MOTORBOAT_SCHEDULE)))).isPresent() ? InteractionResultHolder.success((Object)stack) : InteractionResultHolder.fail((Object)stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        for (int i = 0; i < 3; ++i) {
            tooltipComponents.add((Component)Component.translatable((String)("tooltip.cargoboats.motorboat_programmer_instructions." + i)).withStyle(ChatFormatting.AQUA));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return !((MotorboatSchedule)stack.get(CargoBoats.MOTORBOAT_SCHEDULE)).entries().isEmpty();
    }
}

