/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.item;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.network.TrackMotorboatPacket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

@EventBusSubscriber
public class MotorboatTrackerItem
extends Item {
    private static final Map<Player, Vector3f> playerToTracked = new WeakHashMap<Player, Vector3f>();

    public MotorboatTrackerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(CargoBoats.TRACKED_MOTORBOAT);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.cargoboats.motorboat_tracker").withStyle(ChatFormatting.AQUA));
        UUID uuid = (UUID)stack.get(CargoBoats.TRACKED_MOTORBOAT);
        if (uuid != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.cargoboats.tracked_motorboat", (Object[])new Object[]{uuid.toString()}).withStyle(ChatFormatting.YELLOW));
        }
    }

    @SubscribeEvent
    private static void onPlayerTick(PlayerTickEvent.Pre event) {
        Level level = event.getEntity().level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Optional<Vector3f> pos = Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)event.getEntity()).getItemInHand(arg_0)).map(stack -> (UUID)stack.get(CargoBoats.TRACKED_MOTORBOAT)).filter(Objects::nonNull).map(arg_0 -> ((ServerLevel)level2).getEntity(arg_0)).filter(Objects::nonNull).findFirst().map(ent -> ent.position().toVector3f());
            Vector3f unwrappedPos = pos.orElse(null);
            if (!Objects.equals(playerToTracked.get(event.getEntity()), unwrappedPos)) {
                playerToTracked.put(event.getEntity(), unwrappedPos);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new TrackMotorboatPacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

