/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.level;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.block.MotorboatPathfindingNode;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT})
public class LevelRendering {
    @Nullable
    public static Vector3f trackedPos = null;

    @SubscribeEvent
    private static void onRenderBlockOutline(RenderHighlightEvent.Block event) {
        MotorboatPathfindingNode cap;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (cap = (MotorboatPathfindingNode)level.getCapability(CargoBoats.MOTORBOAT_PATHFINDING_NODE, event.getTarget().getBlockPos())) != null) {
            Pair<BlockPos, BlockPos> box = cap.getBoxForMotorboatPathfinding();
            Vec3 cameraPos = event.getCamera().getPosition();
            LevelRendering.renderShape(event.getPoseStack(), event.getMultiBufferSource().getBuffer(RenderType.lines()), Shapes.create((AABB)AABB.encapsulatingFullBlocks((BlockPos)new BlockPos((Vec3i)box.first()), (BlockPos)new BlockPos((Vec3i)box.second()))), -cameraPos.x, -cameraPos.y, -cameraPos.z, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    private static void onLevelRender(RenderLevelStageEvent event) {
        Entity entity;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES && (entity = event.getCamera().getEntity()) instanceof Player) {
            Player player = (Player)entity;
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            Vec3 cameraPos = event.getCamera().getPosition();
            if (trackedPos != null) {
                VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
                PoseStack poseStack = event.getPoseStack();
                PoseStack.Pose pose = poseStack.last();
                float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
                float startX = (float)(Mth.lerp((double)partialTick, (double)player.xOld, (double)player.position().x) - cameraPos.x);
                float startY = (float)(Mth.lerp((double)partialTick, (double)player.yOld, (double)player.position().y) - cameraPos.y + (double)player.getEyeHeight() * 0.5);
                float startZ = (float)(Mth.lerp((double)partialTick, (double)player.zOld, (double)player.position().z) - cameraPos.z);
                Vector3f endPos = cameraPos.toVector3f().sub((Vector3fc)trackedPos).negate();
                Vector3f diff = new Vector3f((Vector3fc)endPos).sub(startX, startY, startZ);
                if ((double)diff.lengthSquared() > 0.001) {
                    diff.normalize();
                    consumer.addVertex(pose, startX, startY, startZ).setColor(0, 255, 0, 255).setNormal(pose, diff.x, diff.y, diff.z);
                    consumer.addVertex(pose, endPos).setColor(0, 255, 0, 255).setNormal(pose, diff.x, diff.y, diff.z);
                }
            }
            Arrays.stream(InteractionHand.values()).map(arg_0 -> ((Player)player).getItemInHand(arg_0)).filter(stack -> stack.is(CargoBoats.MOTORBOAT_PROGRAMMER)).findFirst().ifPresent(programmer -> {
                MotorboatSchedule schedule = (MotorboatSchedule)programmer.get(CargoBoats.MOTORBOAT_SCHEDULE);
                LongOpenHashSet dockChecked = new LongOpenHashSet();
                for (MotorboatSchedule.Entry entry : schedule.entries()) {
                    if (entry.dimension() != player.level().dimension() || dockChecked.contains(entry.dock().asLong()) || !player.level().isLoaded(entry.dock())) continue;
                    dockChecked.add(entry.dock().asLong());
                    LevelRendering.renderShape(event.getPoseStack(), bufferSource.getBuffer(RenderType.lines()), Shapes.create((AABB)AABB.encapsulatingFullBlocks((BlockPos)entry.dock(), (BlockPos)entry.dock())), -cameraPos.x, -cameraPos.y, -cameraPos.z, 1.0f, 0.0f, 0.0f, 1.0f);
                }
            });
        }
    }

    private static void renderShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose posestack$pose = poseStack.last();
        shape.forAllEdges((p_323073_, p_323074_, p_323075_, p_323076_, p_323077_, p_323078_) -> {
            float f = (float)(p_323076_ - p_323073_);
            float f1 = (float)(p_323077_ - p_323074_);
            float f2 = (float)(p_323078_ - p_323075_);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            consumer.addVertex(posestack$pose, (float)(p_323073_ + x), (float)(p_323074_ + y), (float)(p_323075_ + z)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f /= f3, f1 /= f3, f2 /= f3);
            consumer.addVertex(posestack$pose, (float)(p_323076_ + x), (float)(p_323077_ + y), (float)(p_323078_ + z)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f, f1, f2);
        });
    }
}

