/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.block.entity.BuoyBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class BuoyMenu
extends AbstractContainerMenu {
    public BuoyBlockEntity buoy;

    public BuoyMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extra) {
        super(CargoBoats.BUOY_MENU.get(), containerId);
        this.buoy = ClientRetrieveBuoy.fromPos(extra.readBlockPos());
    }

    public BuoyMenu(int containerId, BuoyBlockEntity buoy) {
        super(CargoBoats.BUOY_MENU.get(), containerId);
        this.buoy = buoy;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.buoy != null && !this.buoy.isRemoved() && player.canInteractWithBlock(this.buoy.getBlockPos(), 4.0);
    }

    private static class ClientRetrieveBuoy {
        private ClientRetrieveBuoy() {
        }

        public static BuoyBlockEntity fromPos(BlockPos pos) {
            return Minecraft.getInstance().level.getBlockEntity(pos, CargoBoats.BUOY_TE.get()).orElse(null);
        }
    }
}

