/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DynamicIndexSlot
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final IItemHandler itemHandler;
    protected final IntSupplier indexSupplier;

    public DynamicIndexSlot(IItemHandler itemHandler, IntSupplier indexSupplier, int xPosition, int yPosition) {
        super(emptyInventory, indexSupplier.getAsInt(), xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.indexSupplier = indexSupplier;
    }

    public boolean mayPlace(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.itemHandler.isItemValid(this.indexSupplier.getAsInt(), stack);
    }

    @Nonnull
    public ItemStack getItem() {
        return this.getItemHandler().getStackInSlot(this.indexSupplier.getAsInt());
    }

    public void set(@Nonnull ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.indexSupplier.getAsInt(), stack);
        this.setChanged();
    }

    public void onQuickCraft(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return this.itemHandler.getSlotLimit(this.indexSupplier.getAsInt());
    }

    public int getMaxStackSize(ItemStack stack) {
        return Math.min(stack.getMaxStackSize(), this.itemHandler.getSlotLimit(this.indexSupplier.getAsInt()));
    }

    public boolean mayPickup(@Nonnull Player playerIn) {
        return !this.getItemHandler().extractItem(this.indexSupplier.getAsInt(), 1, true).isEmpty();
    }

    @Nonnull
    public ItemStack remove(int amount) {
        return this.getItemHandler().extractItem(this.indexSupplier.getAsInt(), amount, false);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

