/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.entity.FluidMotorboat;
import com.landmaster.cargoboats.item.MotorboatUpgradeItemHandler;
import com.landmaster.cargoboats.menu.MotorboatUpgradeSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FluidMotorboatMenu
extends AbstractContainerMenu {
    @Nullable
    private FluidMotorboat fluidMotorboat = null;

    public FluidMotorboatMenu(int containerId, Inventory playerInventory) {
        this(CargoBoats.FLUID_MOTORBOAT_MENU.get(), containerId, playerInventory, new MotorboatUpgradeItemHandler(CargoBoats.MOTORBOAT.get(), 5), (ContainerData)new SimpleContainerData(4));
    }

    public FluidMotorboatMenu(int containerId, Inventory playerInventory, FluidMotorboat motorboat) {
        this(CargoBoats.FLUID_MOTORBOAT_MENU.get(), containerId, playerInventory, motorboat.upgradeHandler, motorboat.containerData);
        this.fluidMotorboat = motorboat;
    }

    public FluidMotorboatMenu(MenuType<?> type, int containerId, Inventory playerInventory, MotorboatUpgradeItemHandler upgradeHandler, ContainerData containerData) {
        super(type, containerId);
        for (int i = 0; i < 5; ++i) {
            this.addSlot((Slot)new MotorboatUpgradeSlot(upgradeHandler, i, 80 + i * 18, 46));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, row * 9 + col + 9, 8 + col * 18, 72 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 130));
        }
        this.addDataSlots(containerData);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 5 ? !this.moveItemStackTo(itemstack1, 5, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 5, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.fluidMotorboat == null || player.canInteractWithEntity((Entity)this.fluidMotorboat, 4.0);
    }
}

