/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.entity.FluidMotorboat;
import com.landmaster.cargoboats.menu.FluidMotorboatMenu;
import com.landmaster.cargoboats.menu.MotorboatAutomationButton;
import com.landmaster.cargoboats.util.ClientUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;

public class FluidMotorboatScreen
extends AbstractContainerScreen<FluidMotorboatMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/container/fluid_motorboat.png");

    public FluidMotorboatScreen(FluidMotorboatMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 161;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new MotorboatAutomationButton(this.leftPos + 154, this.topPos + 5, () -> ((DataSlot)((DataSlot)((FluidMotorboatMenu)this.menu).dataSlots.get(1))).get(), CONTAINER_BACKGROUND));
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        Entity entity = Minecraft.getInstance().level.getEntity(((DataSlot)((FluidMotorboatMenu)this.menu).dataSlots.get(0)).get());
        if (entity instanceof FluidMotorboat) {
            FluidMotorboat motorboat = (FluidMotorboat)entity;
            motorboat.nextStop().ifPresent(entry -> {
                MutableComponent componentToDraw = Component.translatable((String)"gui.cargoboats.next_stop", (Object[])new Object[]{motorboat.nextStopIndex()});
                int x = this.leftPos + 8;
                int y = this.topPos + 34;
                guiGraphics.drawString(this.font, (Component)componentToDraw, x, y, -16777216, false);
                int width = this.font.width((FormattedText)componentToDraw);
                if (mouseX >= x && mouseY >= y && mouseX < x + width) {
                    Objects.requireNonNull(this.font);
                    if (mouseY < y + 9) {
                        guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.cargoboats.next_stop", (Object[])new Object[]{entry.dock().toShortString(), entry.dimension().location().toString()}), mouseX, mouseY);
                    }
                }
            });
            ClientUtil.drawEnergyBarTooltip(motorboat.getEnergyStored(), motorboat.getMaxEnergyStored(), guiGraphics, this.leftPos + 8, this.topPos + 16, mouseX, mouseY, this.font);
            ClientUtil.drawFluidBarTooltip(motorboat.tank.getFluid(), motorboat.tank.getCapacity(), guiGraphics, this.leftPos + 8, this.topPos + 47, mouseX, mouseY, this.font);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(CONTAINER_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        Entity entity = Minecraft.getInstance().level.getEntity(((DataSlot)((FluidMotorboatMenu)this.menu).dataSlots.get(0)).get());
        if (entity instanceof FluidMotorboat) {
            FluidMotorboat motorboat = (FluidMotorboat)entity;
            ClientUtil.drawEnergyBar(motorboat.getEnergyStored(), motorboat.getMaxEnergyStored(), guiGraphics, this.leftPos + 8, this.topPos + 16);
            ClientUtil.drawFluidBar(motorboat.tank.getFluid(), motorboat.tank.getCapacity(), guiGraphics, this.leftPos + 8, this.topPos + 47);
        }
    }
}

