/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.network.SetAutomationPacket;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

class MotorboatAutomationButton
extends Button {
    private static final Tooltip[] TOOLTIPS = new Tooltip[]{Tooltip.create((Component)Component.translatable((String)"tooltip.cargoboats.automation_disabled")), Tooltip.create((Component)Component.translatable((String)"tooltip.cargoboats.automation_enabled"))};
    private final IntSupplier automationEnabledSupplier;
    private final ResourceLocation atlas;

    public MotorboatAutomationButton(int x, int y, IntSupplier automationEnabledSupplier, ResourceLocation atlas) {
        super(x, y, 16, 16, (Component)Component.translatable((String)"gui.cargoboats.automation_button"), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new SetAutomationPacket(automationEnabledSupplier.getAsInt() == 0), (CustomPacketPayload[])new CustomPacketPayload[0]), DEFAULT_NARRATION);
        this.automationEnabledSupplier = automationEnabledSupplier;
        this.atlas = atlas;
    }

    protected void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int automationEnabledValue = this.automationEnabledSupplier.getAsInt();
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(this.atlas, this.getX(), this.getY(), 224 + 16 * automationEnabledValue, 64, this.getWidth(), this.getHeight());
        this.setTooltip(TOOLTIPS[automationEnabledValue]);
    }

    public void renderString(@Nonnull GuiGraphics guiGraphics, @Nonnull Font font, int color) {
    }
}

