/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.entity.Motorboat;
import com.landmaster.cargoboats.item.MotorboatUpgrade;
import com.landmaster.cargoboats.item.MotorboatUpgradeItemHandler;
import com.landmaster.cargoboats.menu.DynamicIndexSlot;
import com.landmaster.cargoboats.menu.MotorboatUpgradeSlot;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MotorboatMenu
extends AbstractContainerMenu {
    @Nullable
    private Motorboat motorboat = null;
    public int page = 0;

    public MotorboatMenu(int containerId, Inventory playerInventory) {
        this(CargoBoats.MOTORBOAT_MENU.get(), containerId, playerInventory, new MotorboatUpgradeItemHandler(CargoBoats.MOTORBOAT.get(), 5), (IItemHandler)new ItemStackHandler(27), (ContainerData)new SimpleContainerData(4), false);
    }

    public MotorboatMenu(int containerId, Inventory playerInventory, Motorboat motorboat) {
        this(CargoBoats.MOTORBOAT_MENU.get(), containerId, playerInventory, motorboat.upgradeHandler, (IItemHandler)motorboat.itemHandler, motorboat.containerData, true);
        this.motorboat = motorboat;
    }

    public MotorboatMenu(MenuType<?> type, int containerId, Inventory playerInventory, MotorboatUpgradeItemHandler upgradeHandler, IItemHandler itemHandler, ContainerData containerData, boolean paginateItems) {
        super(type, containerId);
        int col;
        int row;
        for (int i = 0; i < 5; ++i) {
            this.addSlot((Slot)new MotorboatUpgradeSlot(upgradeHandler, i, 80 + i * 18, 46));
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int theRow = row;
                int theCol = col;
                this.addSlot(new DynamicIndexSlot(itemHandler, () -> (paginateItems ? this.page * 27 : 0) + theRow * 9 + theCol, 8 + col * 18, 72 + row * 18){

                    @Override
                    public boolean mayPlace(ItemStack stack) {
                        return MotorboatMenu.this.page < ((DataSlot)MotorboatMenu.this.dataSlots.get(2)).get() && super.mayPlace(stack);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, row * 9 + col + 9, 8 + col * 18, 139 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 197));
        }
        this.addDataSlots(containerData);
    }

    public Optional<Motorboat> getMotorboat() {
        return Optional.ofNullable(this.motorboat);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 32 ? !this.moveItemStackTo(itemstack1, 32, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, itemstack1.getItem() instanceof MotorboatUpgrade ? 5 : 32, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.motorboat == null || player.canInteractWithEntity((Entity)this.motorboat, 4.0);
    }
}

