/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.menu.MotorboatProgrammerMenu;
import com.landmaster.cargoboats.network.ModifySchedulePacket;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class MotorboatProgrammerScreen
extends AbstractContainerScreen<MotorboatProgrammerMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/container/motorboat_programmer.png");
    private int page = 0;
    public static final int PAGE_SIZE = 12;

    public MotorboatProgrammerScreen(MotorboatProgrammerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 208;
        this.imageHeight = 222;
    }

    protected void init() {
        super.init();
        for (int i = 0; i < 12; ++i) {
            this.addRenderableWidget((GuiEventListener)new AdjustingButton(this.leftPos + 8, this.topPos + 32 + i * 12, i, -10));
            this.addRenderableWidget((GuiEventListener)new AdjustingButton(this.leftPos + 50, this.topPos + 32 + i * 12, i, 10));
            this.addRenderableWidget((GuiEventListener)new AdjustingButton(this.leftPos + 190, this.topPos + 32 + i * 12, i, Integer.MIN_VALUE));
        }
        this.addRenderableWidget((GuiEventListener)new PageButton(this, this.leftPos + this.imageWidth / 2 - 32 - 6, this.topPos + 20, -1));
        this.addRenderableWidget((GuiEventListener)new PageButton(this, this.leftPos + this.imageWidth / 2 + 32 - 6, this.topPos + 20, 1));
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MotorboatSchedule schedule = ((MotorboatProgrammerMenu)this.menu).getSchedule();
        for (int i = 0; i < 12; ++i) {
            for (Renderable renderable : this.renderables) {
                if (!(renderable instanceof AdjustingButton)) continue;
                AdjustingButton button = (AdjustingButton)renderable;
                button.visible = button.adjustedIndex() < schedule.entries().size();
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        MutableComponent pageComponent = Component.translatable((String)"gui.cargoboats.page", (Object[])new Object[]{this.page + 1, 1 + (schedule.entries().size() - 1) / 12});
        guiGraphics.drawString(this.font, (Component)pageComponent, this.leftPos + (this.imageWidth - this.font.width((FormattedText)pageComponent)) / 2, this.topPos + 22, -16777216, false);
        for (int i = this.page * 12; i < schedule.entries().size() && i < (this.page + 1) * 12; ++i) {
            MotorboatSchedule.Entry entry = schedule.entries().get(i);
            int x = this.leftPos + 36;
            int y = this.topPos + 34 + i % 12 * 12;
            MutableComponent component = Component.literal((String)Integer.toString(entry.stopTime()));
            guiGraphics.drawString(this.font, (Component)component, x - this.font.width((FormattedText)component) / 2, y, -16777216, false);
            x = this.leftPos + 66;
            component = Component.translatable((String)"gui.cargoboats.motorboat_schedule", (Object[])new Object[]{i, entry.dock().toShortString()});
            guiGraphics.drawString(this.font, (Component)component, x, y, -16777216, false);
            if (mouseX < x || mouseY < y || mouseX >= x + this.font.width((FormattedText)component)) continue;
            Objects.requireNonNull(this.font);
            if (mouseY >= y + 9) continue;
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.cargoboats.motorboat_schedule", (Object[])new Object[]{entry.dock().toShortString(), entry.dimension().location().toString(), entry.stopTime()}), mouseX, mouseY);
        }
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(CONTAINER_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    private class AdjustingButton
    extends Button {
        private final int index;
        public final int delta;

        public AdjustingButton(int x, int y, int index, int delta) {
            super(x, y, 12, 12, (Component)Component.literal((String)(delta == Integer.MIN_VALUE ? "" : (delta >= 0 ? "+" : "-"))), btn -> {}, DEFAULT_NARRATION);
            this.index = index;
            this.delta = delta;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cargoboats.programmer_adjust", (Object[])new Object[]{delta, 10 * delta})));
        }

        public void onPress() {
            boolean isShifting = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344);
            PacketDistributor.sendToServer((CustomPacketPayload)new ModifySchedulePacket(this.adjustedIndex(), isShifting ? 10 * this.delta : this.delta), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            if (this.delta == Integer.MIN_VALUE) {
                guiGraphics.blit(CONTAINER_BACKGROUND, this.getX(), this.getY(), 240, 0, 12, 12);
            }
        }

        public void renderString(@Nonnull GuiGraphics guiGraphics, @Nonnull Font font, int color) {
            if (this.delta != Integer.MIN_VALUE) {
                super.renderString(guiGraphics, font, color);
            }
        }

        public int adjustedIndex() {
            return MotorboatProgrammerScreen.this.page * 12 + this.index;
        }
    }

    private class PageButton
    extends Button {
        public PageButton(MotorboatProgrammerScreen motorboatProgrammerScreen, int x, int y, int delta) {
            super(x, y, 12, 12, (Component)Component.literal((String)(delta >= 0 ? "+" : "-")), btn -> {
                com$landmaster$cargoboats$menu$MotorboatProgrammerScreen$this.page = Math.clamp((long)(com$landmaster$cargoboats$menu$MotorboatProgrammerScreen$this.page + delta), 0, (((MotorboatProgrammerMenu)motorboatProgrammerScreen.menu).getSchedule().entries().size() - 1) / 12);
            }, DEFAULT_NARRATION);
        }
    }
}

