/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.menu;

import com.landmaster.cargoboats.entity.Motorboat;
import com.landmaster.cargoboats.menu.MotorboatAutomationButton;
import com.landmaster.cargoboats.menu.MotorboatMenu;
import com.landmaster.cargoboats.network.SetMotorboatPagePacket;
import com.landmaster.cargoboats.util.ClientUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.neoforged.neoforge.network.PacketDistributor;

public class MotorboatScreen
extends AbstractContainerScreen<MotorboatMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/container/motorboat.png");

    public MotorboatScreen(MotorboatMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new MotorboatAutomationButton(this.leftPos + 154, this.topPos + 5, () -> ((DataSlot)((DataSlot)((MotorboatMenu)this.menu).dataSlots.get(1))).get(), CONTAINER_BACKGROUND));
        this.addRenderableWidget((GuiEventListener)new PageButton(this, this.leftPos + 8, this.topPos + 44, 1));
        this.addRenderableWidget((GuiEventListener)new PageButton(this, this.leftPos + 8, this.topPos + 56, -1));
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ChatFormatting[] chatFormattingArray;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int writePageLimit = ((DataSlot)((MotorboatMenu)this.menu).dataSlots.get(2)).get();
        int readPageLimit = ((DataSlot)((MotorboatMenu)this.menu).dataSlots.get(3)).get();
        if (((MotorboatMenu)this.menu).page < writePageLimit) {
            chatFormattingArray = new ChatFormatting[]{};
        } else {
            ChatFormatting[] chatFormattingArray2 = new ChatFormatting[1];
            chatFormattingArray = chatFormattingArray2;
            chatFormattingArray2[0] = ChatFormatting.STRIKETHROUGH;
        }
        ChatFormatting[] pageStyle = chatFormattingArray;
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)(writePageLimit < readPageLimit ? "gui.cargoboats.page.asterisk" : "gui.cargoboats.page"), (Object[])new Object[]{((MotorboatMenu)this.menu).page + 1, readPageLimit}).withStyle(pageStyle), this.leftPos + 24, this.topPos + 51, -16777216, false);
        Entity entity = Minecraft.getInstance().level.getEntity(((DataSlot)((MotorboatMenu)this.menu).dataSlots.get(0)).get());
        if (entity instanceof Motorboat) {
            Motorboat motorboat = (Motorboat)entity;
            motorboat.nextStop().ifPresent(entry -> {
                MutableComponent componentToDraw = Component.translatable((String)"gui.cargoboats.next_stop", (Object[])new Object[]{motorboat.nextStopIndex()});
                int x = this.leftPos + 8;
                int y = this.topPos + 34;
                guiGraphics.drawString(this.font, (Component)componentToDraw, x, y, -16777216, false);
                int width = this.font.width((FormattedText)componentToDraw);
                if (mouseX >= x && mouseY >= y && mouseX < x + width) {
                    Objects.requireNonNull(this.font);
                    if (mouseY < y + 9) {
                        guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"tooltip.cargoboats.next_stop", (Object[])new Object[]{entry.dock().toShortString(), entry.dimension().location().toString()}), mouseX, mouseY);
                    }
                }
            });
            ClientUtil.drawEnergyBarTooltip(motorboat.getEnergyStored(), motorboat.getMaxEnergyStored(), guiGraphics, this.leftPos + 8, this.topPos + 16, mouseX, mouseY, this.font);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(CONTAINER_BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        Entity entity = Minecraft.getInstance().level.getEntity(((DataSlot)((MotorboatMenu)this.menu).dataSlots.get(0)).get());
        if (entity instanceof Motorboat) {
            Motorboat motorboat = (Motorboat)entity;
            ClientUtil.drawEnergyBar(motorboat.getEnergyStored(), motorboat.getMaxEnergyStored(), guiGraphics, this.leftPos + 8, this.topPos + 16);
        }
    }

    private class PageButton
    extends Button {
        public PageButton(MotorboatScreen motorboatScreen, int x, int y, int delta) {
            super(x, y, 12, 12, (Component)Component.literal((String)(delta >= 0 ? "+" : "-")), btn -> {
                int readPageLimit = ((DataSlot)((MotorboatMenu)((MotorboatScreen)com$landmaster$cargoboats$menu$MotorboatScreen$this).menu).dataSlots.get(3)).get();
                PacketDistributor.sendToServer((CustomPacketPayload)new SetMotorboatPagePacket(Math.clamp((long)(((MotorboatMenu)((MotorboatScreen)com$landmaster$cargoboats$menu$MotorboatScreen$this).menu).page + delta), 0, readPageLimit - 1)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }, DEFAULT_NARRATION);
        }
    }
}

