/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.network;

import com.landmaster.cargoboats.menu.MotorboatProgrammerMenu;
import com.landmaster.cargoboats.util.MotorboatSchedule;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ModifySchedulePacket(int index, int delta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ModifySchedulePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"modify_schedule"));
    public static final StreamCodec<ByteBuf, ModifySchedulePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ModifySchedulePacket::index, (StreamCodec)ByteBufCodecs.INT, ModifySchedulePacket::delta, ModifySchedulePacket::new);

    public void handle(IPayloadContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.player().containerMenu;
        if (abstractContainerMenu instanceof MotorboatProgrammerMenu) {
            MotorboatProgrammerMenu menu = (MotorboatProgrammerMenu)abstractContainerMenu;
            ArrayList<MotorboatSchedule.Entry> newEntries = new ArrayList<MotorboatSchedule.Entry>(menu.getSchedule().entries());
            if (this.index >= 0 && this.index < newEntries.size()) {
                if (this.delta == Integer.MIN_VALUE) {
                    newEntries.remove(this.index);
                } else {
                    MotorboatSchedule.Entry oldEntry = newEntries.get(this.index);
                    int newStopTime = Math.clamp((long)(oldEntry.stopTime() + this.delta), 0, 20000);
                    newEntries.set(this.index, new MotorboatSchedule.Entry(oldEntry.dock(), newStopTime, oldEntry.dimension()));
                }
            }
            menu.setSchedule(new MotorboatSchedule(newEntries));
            if (!ctx.player().level().isClientSide) {
                ctx.reply((CustomPacketPayload)this);
            }
        }
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

