/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.network;

import com.landmaster.cargoboats.block.entity.BuoyBlockEntity;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncBuoyPacket(BlockPos pos, byte offsetX, byte offsetZ) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBuoyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"sync_buoy"));
    public static final StreamCodec<ByteBuf, SyncBuoyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncBuoyPacket::pos, (StreamCodec)ByteBufCodecs.BYTE, SyncBuoyPacket::offsetX, (StreamCodec)ByteBufCodecs.BYTE, SyncBuoyPacket::offsetZ, SyncBuoyPacket::new);

    public void handle(IPayloadContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.player().level();
        ChunkPos chunkPos = new ChunkPos(this.pos);
        if (level.hasChunk(chunkPos.x, chunkPos.z) && (blockEntity = level.getBlockEntity(this.pos)) instanceof BuoyBlockEntity) {
            BuoyBlockEntity te = (BuoyBlockEntity)blockEntity;
            te.offsetX = Math.clamp((long)this.offsetX, -3, 3);
            te.offsetZ = Math.clamp((long)this.offsetZ, -3, 3);
            te.setChanged();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)this, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

