/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.sound;

import com.landmaster.cargoboats.CargoBoats;
import com.landmaster.cargoboats.entity.Motorboat;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;

public class MotorboatSoundInstance
extends AbstractTickableSoundInstance {
    private final Motorboat motorboat;

    public MotorboatSoundInstance(Motorboat motorboat) {
        super(CargoBoats.MOTORBOAT_SOUND.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.motorboat = motorboat;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.x = motorboat.getX();
        this.y = motorboat.getY();
        this.z = motorboat.getZ();
    }

    public boolean canPlaySound() {
        return !this.motorboat.isSilent();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (this.motorboat.isRemoved()) {
            this.stop();
        } else {
            this.x = this.motorboat.getX();
            this.y = this.motorboat.getY();
            this.z = this.motorboat.getZ();
            this.volume = this.motorboat.rotorSpeed * 0.7f;
        }
    }
}

