/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class ClientUtil {
    public static final ResourceLocation POWER_METER_UNACTIVATED = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/util/power_meter_unactivated.png");
    public static final ResourceLocation POWER_METER = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/util/power_meter.png");
    public static final ResourceLocation FLUID_METER = ResourceLocation.fromNamespaceAndPath((String)"cargoboats", (String)"textures/gui/util/fluid_meter.png");

    public static void drawEnergyBar(int energy, int maxEnergy, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(POWER_METER_UNACTIVATED, x, y, 0.0f, 0.0f, 128, 16, 128, 16);
        guiGraphics.blit(POWER_METER, x, y, 0.0f, 0.0f, Math.clamp(14L + 114L * (long)energy / (long)maxEnergy, 14, 114), 16, 128, 16);
    }

    public static void drawEnergyBarTooltip(int energy, int maxEnergy, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Font font) {
        if (x <= mouseX && mouseX < x + 128 && y <= mouseY && mouseY < y + 16) {
            guiGraphics.renderTooltip(font, (Component)Component.translatable((String)"gui.cargoboats.rf_indicator", (Object[])new Object[]{energy, maxEnergy}), mouseX, mouseY);
        }
    }

    public static void drawFluidBarTooltip(FluidStack fluidStack, int capacity, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, Font font) {
        if (x <= mouseX && mouseX < x + 64 && y <= mouseY && mouseY < y + 12) {
            guiGraphics.renderTooltip(font, (Component)Component.translatable((String)"gui.cargoboats.fluid_indicator", (Object[])new Object[]{fluidStack.getHoverName(), fluidStack.getAmount(), capacity}), mouseX, mouseY);
        }
    }

    public static void drawFluidBar(FluidStack fluidStack, int capacity, GuiGraphics guiGraphics, int x, int y) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        if (attributes == null) {
            return;
        }
        ResourceLocation fluidStill = attributes.getStillTexture(fluidStack);
        if (fluidStill == null) {
            return;
        }
        int color = attributes.getTintColor();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        guiGraphics.blit(x, y, 0, Math.clamp(64L * (long)fluidStack.getAmount() / (long)capacity, 0, 64), 12, sprite, (float)FastColor.ARGB32.red((int)color) / 256.0f, (float)FastColor.ARGB32.green((int)color) / 256.0f, (float)FastColor.ARGB32.blue((int)color) / 256.0f, (float)FastColor.ARGB32.alpha((int)color) / 256.0f);
        guiGraphics.blit(FLUID_METER, x, y, 0.0f, 0.0f, 64, 12, 64, 32);
    }
}

