/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FluidRenderUtil {
    private static void addQuadVertex(PoseStack.Pose pose, VertexConsumer renderBuffer, Vector3f pos, Vector2f texUV, Vector3f normalVector, int color, int lightmapValue) {
        renderBuffer.addVertex(pose, pos.x(), pos.y(), pos.z()).setColor(color).setUv(texUV.x, texUV.y).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 240).setNormal(pose, normalVector.x(), normalVector.y(), normalVector.z());
    }

    private static void addQuad(PoseStack.Pose pose, VertexConsumer renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vector2f blUVpos, Vector2f brUVpos, Vector2f trUVpos, Vector2f tlUVpos, Vector3f normalVector, int color, int lightmapValue) {
        FluidRenderUtil.addQuadVertex(pose, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(pose, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(pose, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(pose, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addFace(Direction whichFace, PoseStack.Pose pose, VertexConsumer renderBuffer, int color, Vector3f centrePos, float width, float height, Vector2f bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vector3f leftToRightDirection;
        Vector3f bottomToTopDirection = switch (whichFace) {
            case Direction.NORTH -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.SOUTH -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.EAST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.WEST -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
            case Direction.UP -> {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case Direction.DOWN -> {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                yield new Vector3f(0.0f, 0.0f, 1.0f);
            }
            default -> {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                yield new Vector3f(0.0f, 1.0f, 0.0f);
            }
        };
        leftToRightDirection.mul(0.5f * width);
        bottomToTopDirection.mul(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f((Vector3fc)centrePos);
        bottomLeftPos.sub((Vector3fc)leftToRightDirection);
        bottomLeftPos.sub((Vector3fc)bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f((Vector3fc)centrePos);
        bottomRightPos.add((Vector3fc)leftToRightDirection);
        bottomRightPos.sub((Vector3fc)bottomToTopDirection);
        Vector3f topRightPos = new Vector3f((Vector3fc)centrePos);
        topRightPos.add((Vector3fc)leftToRightDirection);
        topRightPos.add((Vector3fc)bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f((Vector3fc)centrePos);
        topLeftPos.sub((Vector3fc)leftToRightDirection);
        topLeftPos.add((Vector3fc)bottomToTopDirection);
        Vector2f bottomLeftUVpos = new Vector2f(bottomLeftUV.x, bottomLeftUV.y);
        Vector2f bottomRightUVpos = new Vector2f(bottomLeftUV.x + texUwidth, bottomLeftUV.y);
        Vector2f topLeftUVpos = new Vector2f(bottomLeftUV.x + texUwidth, bottomLeftUV.y + texVheight);
        Vector2f topRightUVpos = new Vector2f(bottomLeftUV.x, bottomLeftUV.y + texVheight);
        Vector3f normalVector = whichFace.step();
        FluidRenderUtil.addQuad(pose, renderBuffer, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    public static void renderCubeUsingQuads(FluidStack fluid, float partialTicks, PoseStack PoseStack2, MultiBufferSource renderBuffers, int combinedLight, int combinedOverlay) {
        FluidRenderUtil.drawCubeQuads(PoseStack2, renderBuffers, combinedLight, fluid);
    }

    private static void drawCubeQuads(PoseStack poseStack, MultiBufferSource renderBuffer, int combinedLight, FluidStack fluid) {
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        if (attributes == null) {
            return;
        }
        ResourceLocation fluidStill = attributes.getStillTexture(fluid);
        if (fluidStill == null) {
            return;
        }
        VertexConsumer vertexBuilderBlockQuads = renderBuffer.getBuffer(RenderType.translucent());
        int color = attributes.getTintColor();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidStill);
        Vector2f bottomLeftUV = new Vector2f(sprite.getU0(), sprite.getV0());
        float UVwidth = sprite.getU1() - sprite.getU0();
        float UVheight = sprite.getV1() - sprite.getV0();
        float WIDTH = 1.0f;
        float HEIGHT = 1.0f;
        Vector3f EAST_FACE_MIDPOINT = new Vector3f(1.0f, 0.5f, 0.5f);
        Vector3f WEST_FACE_MIDPOINT = new Vector3f(0.0f, 0.5f, 0.5f);
        Vector3f NORTH_FACE_MIDPOINT = new Vector3f(0.5f, 0.5f, 0.0f);
        Vector3f SOUTH_FACE_MIDPOINT = new Vector3f(0.5f, 0.5f, 1.0f);
        Vector3f UP_FACE_MIDPOINT = new Vector3f(0.5f, 1.0f, 0.5f);
        Vector3f DOWN_FACE_MIDPOINT = new Vector3f(0.5f, 0.0f, 0.5f);
        PoseStack.Pose pose = poseStack.last();
        FluidRenderUtil.addFace(Direction.EAST, pose, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.WEST, pose, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.NORTH, pose, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.SOUTH, pose, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.UP, pose, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.DOWN, pose, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }
}

