/*
 * Decompiled with CFR 0.152.
 */
package com.landmaster.cargoboats.util;

import com.landmaster.cargoboats.block.WrenchInteractable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class WrenchHook {
    public static final TagKey<Item> WRENCH_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/wrench"));

    @SubscribeEvent
    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getItemStack().is(WRENCH_TAG)) {
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof WrenchInteractable) {
                WrenchInteractable wrenchInteractable = (WrenchInteractable)block;
                InteractionResult result = InteractionResult.PASS;
                result = event.getEntity().isSecondaryUseActive() ? wrenchInteractable.disassemble(event.getLevel(), event.getPos(), event.getEntity()) : wrenchInteractable.rotate(event.getLevel(), event.getPos(), event.getEntity());
                if (result != InteractionResult.PASS) {
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                }
            }
        }
    }
}

