/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import yagen.waitmydawn.PackUp;
import yagen.waitmydawn.PlayerLootData;

public class LootStorageMenu
extends AbstractContainerMenu {
    private final PlayerLootData lootData;
    private final Inventory playerInventory;
    private final PageProxyContainer proxyContainer;
    private int clientTotalPages = 0;
    private int currentPage = 0;
    private static final SimpleContainer EMPTY_CONTAINER = new SimpleContainer(27);

    public LootStorageMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(containerId, playerInv);
    }

    public LootStorageMenu(int containerId, final Inventory playerInv) {
        super(PackUp.LOOT_MENU.get(), containerId);
        this.playerInventory = playerInv;
        this.lootData = (PlayerLootData)playerInv.player.getData(PackUp.LOOT_DATA);
        this.proxyContainer = new PageProxyContainer();
        this.refreshProxyTarget();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot(this, this.proxyContainer, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }
                });
            }
        }
        this.addPlayerSlots(playerInv);
        this.addDataSlot(new DataSlot(){

            public int get() {
                return LootStorageMenu.this.currentPage;
            }

            public void set(int value) {
                LootStorageMenu.this.currentPage = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return playerInv.player.level().isClientSide() ? LootStorageMenu.this.clientTotalPages : LootStorageMenu.this.lootData.getPages().size();
            }

            public void set(int value) {
                LootStorageMenu.this.clientTotalPages = value;
            }
        });
    }

    private void addPlayerSlots(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    private void refreshProxyTarget() {
        if (this.lootData.getPages().isEmpty()) {
            this.proxyContainer.setTarget(EMPTY_CONTAINER);
        } else {
            int max = this.lootData.getPages().size();
            if (this.currentPage >= max) {
                this.currentPage = max - 1;
            }
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            this.proxyContainer.setTarget(this.lootData.getPages().get(this.currentPage));
        }
    }

    public void changePage(int offset) {
        int max = this.lootData.getPages().isEmpty() ? 0 : this.lootData.getPages().size();
        int newPage = this.currentPage + offset;
        if (newPage >= 0 && newPage < max) {
            this.currentPage = newPage;
            this.refreshProxyTarget();
            this.broadcastChanges();
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide()) {
            this.lootData.cleanEmptyPages();
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.playerInventory.player.level().isClientSide() ? this.clientTotalPages : this.lootData.getPages().size();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 27) {
                if (!this.moveItemStackTo(itemstack1, 27, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private static class PageProxyContainer
    implements Container {
        private SimpleContainer target = EMPTY_CONTAINER;

        private PageProxyContainer() {
        }

        public void setTarget(SimpleContainer target) {
            this.target = target;
        }

        public int getContainerSize() {
            return this.target.getContainerSize();
        }

        public boolean isEmpty() {
            return this.target.isEmpty();
        }

        public ItemStack getItem(int slot) {
            return this.target.getItem(slot);
        }

        public ItemStack removeItem(int slot, int amount) {
            return this.target.removeItem(slot, amount);
        }

        public ItemStack removeItemNoUpdate(int slot) {
            return this.target.removeItemNoUpdate(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            this.target.setItem(slot, stack);
        }

        public void setChanged() {
            this.target.setChanged();
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void clearContent() {
            this.target.clearContent();
        }
    }
}

