/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import yagen.waitmydawn.PackUp;
import yagen.waitmydawn.PlayerLootData;

public record PacketStoreLoot() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketStoreLoot> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"pack_up", (String)"store_loot"));
    public static final StreamCodec<ByteBuf, PacketStoreLoot> STREAM_CODEC = StreamCodec.unit((Object)new PacketStoreLoot());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PacketStoreLoot payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            boolean isValidContainer;
            ServerPlayer player = (ServerPlayer)context.player();
            AbstractContainerMenu menu = player.containerMenu;
            boolean bl = isValidContainer = menu instanceof ChestMenu || menu instanceof ShulkerBoxMenu;
            if (isValidContainer) {
                SimpleContainer newPage = new SimpleContainer(27);
                boolean hasItems = false;
                Container patt0$temp = ((Slot)menu.slots.getFirst()).container;
                if (patt0$temp instanceof BlockEntity) {
                    BlockEntity blockEntity = (BlockEntity)patt0$temp;
                    if (!((Boolean)blockEntity.getData(PackUp.CAN_QUICK_LOOT)).booleanValue()) {
                        return;
                    }
                    blockEntity.setData(PackUp.CAN_QUICK_LOOT, (Object)false);
                }
                int slotCount = 0;
                for (Slot slot : menu.slots) {
                    if (slot.container == player.getInventory()) continue;
                    if (slotCount >= 27) break;
                    if (slot.hasItem()) {
                        newPage.setItem(slotCount, slot.getItem().copy());
                        slot.set(ItemStack.EMPTY);
                        hasItems = true;
                    }
                    ++slotCount;
                }
                if (hasItems) {
                    PlayerLootData data = (PlayerLootData)player.getData(PackUp.LOOT_DATA);
                    data.addPage(newPage);
                    player.level().playSound(null, player.blockPosition(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        });
    }
}

