/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class PlayerLootData {
    private final List<SimpleContainer> pages = new ArrayList<SimpleContainer>();
    private static final Codec<SimpleContainer> PAGE_CODEC = ItemStack.OPTIONAL_CODEC.listOf().xmap(list -> {
        SimpleContainer container = new SimpleContainer(27);
        for (int i = 0; i < list.size() && i < 27; ++i) {
            container.setItem(i, (ItemStack)list.get(i));
        }
        return container;
    }, container -> {
        NonNullList list = NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < container.getContainerSize(); ++i) {
            list.set(i, (Object)container.getItem(i));
        }
        return list;
    });
    public static final MapCodec<PlayerLootData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PAGE_CODEC.listOf().fieldOf("pages").forGetter(data -> data.pages)).apply((Applicative)instance, PlayerLootData::new));

    public PlayerLootData() {
    }

    public PlayerLootData(List<SimpleContainer> pages) {
        this.pages.addAll(pages);
    }

    public List<SimpleContainer> getPages() {
        return this.pages;
    }

    public void addPage(SimpleContainer page) {
        this.pages.add(page);
    }

    public void cleanEmptyPages() {
        this.pages.removeIf(SimpleContainer::isEmpty);
    }
}

