/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PlayerLootData
implements INBTSerializable<CompoundTag> {
    private final List<ItemStackHandler> pages = new ArrayList<ItemStackHandler>();

    public List<ItemStackHandler> getPages() {
        return this.pages;
    }

    public void addPage(ItemStackHandler handler) {
        this.pages.add(handler);
    }

    public void cleanEmptyPages() {
        this.pages.removeIf(this::isHandlerEmpty);
    }

    private boolean isHandlerEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (ItemStackHandler handler : this.pages) {
            list.add((Object)handler.serializeNBT(provider));
        }
        tag.put("Pages", (Tag)list);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.pages.clear();
        ListTag list = tag.getList("Pages").orElseGet(ListTag::new);
        for (Tag value : list) {
            ItemStackHandler handler = new ItemStackHandler(27);
            if (!(value instanceof CompoundTag)) continue;
            CompoundTag pageTag = (CompoundTag)value;
            handler.deserializeNBT(provider, pageTag);
            this.pages.add(handler);
        }
    }
}

