/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import yagen.waitmydawn.PackUp;
import yagen.waitmydawn.PlayerLootData;

public class LootStorageMenu
extends AbstractContainerMenu {
    private final PlayerLootData lootData;
    private final Inventory playerInventory;
    private final PageProxyHandler proxyHandler;
    private int clientTotalPages = 0;
    private int currentPage = 0;
    private static final ItemStackHandler EMPTY_HANDLER = new ItemStackHandler(27);

    public LootStorageMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(containerId, playerInv);
    }

    public LootStorageMenu(int containerId, Inventory playerInv) {
        super(PackUp.LOOT_MENU.get(), containerId);
        this.playerInventory = playerInv;
        this.lootData = (PlayerLootData)playerInv.player.getData(PackUp.LOOT_DATA);
        this.proxyHandler = new PageProxyHandler();
        this.refreshProxyTarget();
        this.addStorageSlots();
        this.addPlayerSlots(playerInv);
        this.addDataSlot(new DataSlot(){

            public int get() {
                return LootStorageMenu.this.currentPage;
            }

            public void set(int value) {
                LootStorageMenu.this.currentPage = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return LootStorageMenu.this.lootData.getPages().isEmpty() ? 0 : LootStorageMenu.this.lootData.getPages().size();
            }

            public void set(int value) {
                LootStorageMenu.this.clientTotalPages = value;
            }
        });
    }

    private void refreshProxyTarget() {
        if (this.lootData.getPages().isEmpty()) {
            this.proxyHandler.setTarget((IItemHandlerModifiable)EMPTY_HANDLER);
        } else {
            int max = this.lootData.getPages().size();
            if (this.currentPage >= max) {
                this.currentPage = max - 1;
            }
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            this.proxyHandler.setTarget((IItemHandlerModifiable)this.lootData.getPages().get(this.currentPage));
        }
    }

    private void addStorageSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.proxyHandler, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }
                });
            }
        }
    }

    private void addPlayerSlots(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public void changePage(int offset) {
        int max = this.lootData.getPages().isEmpty() ? 0 : this.lootData.getPages().size();
        int newPage = this.currentPage + offset;
        if (newPage >= 0 && newPage < max) {
            this.currentPage = newPage;
            this.refreshProxyTarget();
            this.broadcastChanges();
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.playerInventory.player.level().isClientSide ? this.clientTotalPages : this.lootData.getPages().size();
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.lootData.cleanEmptyPages();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 27) {
                if (!this.moveItemStackTo(itemstack1, 27, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private static class PageProxyHandler
    implements IItemHandlerModifiable {
        private IItemHandlerModifiable target = EMPTY_HANDLER;

        private PageProxyHandler() {
        }

        public void setTarget(IItemHandlerModifiable target) {
            this.target = target;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.target.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.target.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.target.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.target.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.target.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.target.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.target.isItemValid(slot, stack);
        }
    }
}

