/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import yagen.waitmydawn.PackUp;
import yagen.waitmydawn.PlayerLootData;

public class LootStorageMenu
extends AbstractContainerMenu {
    private final PlayerLootData lootData;
    private final Inventory playerInventory;
    private final PageProxyHandler proxyHandler;
    private int clientTotalPages = 0;
    private int currentPage = 0;
    private static final ItemStackHandler EMPTY_HANDLER = new ItemStackHandler(27);

    public LootStorageMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(containerId, playerInv);
    }

    public LootStorageMenu(int containerId, Inventory playerInv) {
        super((MenuType)PackUp.LOOT_MENU.get(), containerId);
        this.playerInventory = playerInv;
        this.lootData = (PlayerLootData)playerInv.f_35978_.getCapability(PackUp.LOOT_DATA_CAPABILITY).orElseThrow(() -> new IllegalStateException("Player data not present"));
        this.proxyHandler = new PageProxyHandler();
        this.refreshProxyTarget();
        this.addStorageSlots();
        this.addPlayerSlots(playerInv);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return LootStorageMenu.this.currentPage;
            }

            public void m_6422_(int value) {
                LootStorageMenu.this.currentPage = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return LootStorageMenu.this.lootData.getPages().isEmpty() ? 0 : LootStorageMenu.this.lootData.getPages().size();
            }

            public void m_6422_(int value) {
                LootStorageMenu.this.clientTotalPages = value;
            }
        });
    }

    private void refreshProxyTarget() {
        if (this.lootData.getPages().isEmpty()) {
            this.proxyHandler.setTarget((IItemHandlerModifiable)EMPTY_HANDLER);
        } else {
            int max = this.lootData.getPages().size();
            if (this.currentPage >= max) {
                this.currentPage = max - 1;
            }
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            this.proxyHandler.setTarget((IItemHandlerModifiable)this.lootData.getPages().get(this.currentPage));
        }
    }

    private void addStorageSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.proxyHandler, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }
                });
            }
        }
    }

    private void addPlayerSlots(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public void changePage(int offset) {
        int max = this.lootData.getPages().isEmpty() ? 0 : this.lootData.getPages().size();
        int newPage = this.currentPage + offset;
        if (newPage >= 0 && newPage < max) {
            this.currentPage = newPage;
            this.refreshProxyTarget();
            this.m_38946_();
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.playerInventory.f_35978_.m_9236_().f_46443_ ? this.clientTotalPages : this.lootData.getPages().size();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            this.lootData.cleanEmptyPages();
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 27) {
                if (!this.m_38903_(itemstack1, 27, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private static class PageProxyHandler
    implements IItemHandlerModifiable {
        private IItemHandlerModifiable target = EMPTY_HANDLER;

        private PageProxyHandler() {
        }

        public void setTarget(IItemHandlerModifiable target) {
            this.target = target;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.target.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.target.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.target.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.target.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.target.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.target.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.target.isItemValid(slot, stack);
        }
    }
}

