/*
 * Decompiled with CFR 0.152.
 */
package yagen.waitmydawn;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yagen.waitmydawn.PackUp;

public class PlayerLootData
implements ICapabilitySerializable<CompoundTag> {
    private final List<ItemStackHandler> pages = new ArrayList<ItemStackHandler>();
    private final LazyOptional<PlayerLootData> instance = LazyOptional.of(() -> this);

    public List<ItemStackHandler> getPages() {
        return this.pages;
    }

    public void addPage(ItemStackHandler handler) {
        this.pages.add(handler);
    }

    public void cleanEmptyPages() {
        this.pages.removeIf(this::isHandlerEmpty);
    }

    private boolean isHandlerEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (ItemStackHandler handler : this.pages) {
            list.add((Object)handler.serializeNBT());
        }
        tag.m_128365_("Pages", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.pages.clear();
        ListTag list = tag.m_128437_("Pages", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStackHandler handler = new ItemStackHandler(27);
            handler.deserializeNBT(list.m_128728_(i));
            this.pages.add(handler);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return PackUp.LOOT_DATA_CAPABILITY.orEmpty(cap, this.instance);
    }
}

