/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.exavior.oeuvre.Config;
import net.exavior.oeuvre.entity.custom.IllustratorEntity;
import net.exavior.oeuvre.entity.custom.IllustratorPaperEntity;
import net.exavior.oeuvre.entity.custom.IllustratorVexEntity;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.exavior.oeuvre.network.OeuvNetworkHandler;
import net.exavior.oeuvre.registry.OeuvBlockEntities;
import net.exavior.oeuvre.registry.OeuvBlocks;
import net.exavior.oeuvre.registry.OeuvCreativeModeTabs;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.exavior.oeuvre.registry.OeuvItems;
import net.exavior.oeuvre.registry.OeuvMenus;
import net.exavior.oeuvre.registry.OeuvVillagers;
import net.exavior.oeuvre.util.IllustratorPixelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;

@Mod(value="oeuvre")
public class Oeuvre {
    public static final String MODID = "oeuvre";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Oeuvre(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerPayloadHandler);
        OeuvDataComponents.register(modEventBus);
        OeuvBlockEntities.register(modEventBus);
        OeuvMenus.register(modEventBus);
        OeuvItems.register(modEventBus);
        OeuvBlocks.register(modEventBus);
        OeuvEntityTypes.register(modEventBus);
        OeuvVillagers.register(modEventBus);
        OeuvCreativeModeTabs.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        OeuvNetworkHandler.register(evt.registrar("1.0"));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.LOG_DIRT_BLOCK.getAsBoolean()) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info("{}{}", Config.MAGIC_NUMBER_INTRODUCTION.get(), (Object)Config.MAGIC_NUMBER.getAsInt());
        ((List)Config.ITEM_STRINGS.get()).forEach(item -> LOGGER.info("ITEM >> {}", item));
        event.enqueueWork(IllustratorPixelManager::loadVariations);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="oeuvre")
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void entityAttributeEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)OeuvEntityTypes.SKETCHBOOK_PAPER.get(), SketchBookPaperEntity.createAttributes().build());
            event.put((EntityType)OeuvEntityTypes.ILLUSTRATOR.get(), IllustratorEntity.createAttributes().build());
            event.put((EntityType)OeuvEntityTypes.ILLUSTRATOR_PAPER.get(), IllustratorPaperEntity.createAttributes().build());
            event.put((EntityType)OeuvEntityTypes.ILLUSTRATOR_VEX.get(), IllustratorVexEntity.createAttributes().build());
        }
    }
}

