/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre;

import net.exavior.oeuvre.Oeuvre;
import net.exavior.oeuvre.entity.model.AnimatingItemFrameModel;
import net.exavior.oeuvre.entity.model.GhostModel;
import net.exavior.oeuvre.entity.model.IllustratorModel;
import net.exavior.oeuvre.entity.model.SketchBookPaperModel;
import net.exavior.oeuvre.entity.renderer.AnimatingItemFrameRenderer;
import net.exavior.oeuvre.entity.renderer.IllustratorPaperRenderer;
import net.exavior.oeuvre.entity.renderer.IllustratorRenderer;
import net.exavior.oeuvre.entity.renderer.IllustratorVexRenderer;
import net.exavior.oeuvre.entity.renderer.SketchBookPaperRenderer;
import net.exavior.oeuvre.gui.screen.ArtistDeskScreen;
import net.exavior.oeuvre.gui.tooltip.ClientSketchTooltip;
import net.exavior.oeuvre.gui.tooltip.SketchTooltip;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.exavior.oeuvre.registry.OeuvItemProperties;
import net.exavior.oeuvre.registry.OeuvMenus;
import net.exavior.oeuvre.registry.OeuvModelLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="oeuvre", dist={Dist.CLIENT})
@EventBusSubscriber(modid="oeuvre", value={Dist.CLIENT})
public class OeuvreClient {
    public OeuvreClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public static void registerTooltipFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SketchTooltip.class, ClientSketchTooltip::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(OeuvEntityTypes.ANIMATING_ITEM_FRAME.get(), AnimatingItemFrameRenderer::new);
        event.registerEntityRenderer((EntityType)OeuvEntityTypes.ILLUSTRATOR.get(), IllustratorRenderer::new);
        event.registerEntityRenderer((EntityType)OeuvEntityTypes.ILLUSTRATOR_PAPER.get(), IllustratorPaperRenderer::new);
        event.registerEntityRenderer((EntityType)OeuvEntityTypes.ILLUSTRATOR_VEX.get(), IllustratorVexRenderer::new);
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        Oeuvre.LOGGER.info("HELLO FROM CLIENT SETUP");
        Oeuvre.LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        EntityRenderers.register((EntityType)((EntityType)OeuvEntityTypes.SKETCHBOOK_PAPER.get()), SketchBookPaperRenderer::new);
        OeuvItemProperties.addCustomItemProperties();
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(OeuvMenus.ARTIST_DESK_MENU.get(), ArtistDeskScreen::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(OeuvModelLayers.GHOST_LAYER, GhostModel::createBodyLayer);
        event.registerLayerDefinition(SketchBookPaperModel.LAYER_LOCATION, SketchBookPaperModel::createBodyLayer);
        event.registerLayerDefinition(OeuvModelLayers.ANIMATING_ITEM_FRAME_LAYER, AnimatingItemFrameModel::createBodyLayer);
        event.registerLayerDefinition(IllustratorModel.LAYER_LOCATION, IllustratorModel::createBodyLayer);
    }
}

