/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.custom;

import java.util.List;
import java.util.UUID;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.exavior.oeuvre.item.SketchBookPaperItem;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.exavior.oeuvre.registry.OeuvItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AnimatingItemFrameEntity
extends ItemFrame {
    private UUID spawnedEntityUUID;

    public AnimatingItemFrameEntity(EntityType<? extends ItemFrame> type, Level level) {
        super(type, level);
    }

    public AnimatingItemFrameEntity(Level level, BlockPos pos, Direction direction) {
        super(OeuvEntityTypes.ANIMATING_ITEM_FRAME.get(), level, pos, direction);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 20 == 0) {
            this.checkAndSpawnDrawing();
        }
    }

    private void checkAndSpawnDrawing() {
        boolean hasValidSketch;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = this.getItem();
        boolean bl = hasValidSketch = !stack.isEmpty() && stack.getItem() instanceof SketchBookPaperItem && stack.has(OeuvDataComponents.SKETCH_DATA);
        if (hasValidSketch) {
            Entity existing;
            Entity entity = existing = this.spawnedEntityUUID != null ? serverLevel.getEntity(this.spawnedEntityUUID) : null;
            if (existing == null || !existing.isAlive()) {
                this.spawnSketchEntity(serverLevel, stack);
            } else {
                double distanceSq = existing.distanceToSqr(Vec3.atCenterOf((Vec3i)this.getPos()));
                if (distanceSq > 1764.0) {
                    Vec3 teleportPos = Vec3.atCenterOf((Vec3i)this.getPos()).relative(this.getDirection(), 0.5);
                    existing.teleportTo(teleportPos.x, teleportPos.y, teleportPos.z);
                }
            }
        } else if (this.spawnedEntityUUID != null) {
            Entity entity = serverLevel.getEntity(this.spawnedEntityUUID);
            if (entity instanceof SketchBookPaperEntity) {
                entity.discard();
            }
            this.spawnedEntityUUID = null;
        }
    }

    private void spawnSketchEntity(ServerLevel level, ItemStack stack) {
        SketchBookPaperEntity entity = (SketchBookPaperEntity)((EntityType)OeuvEntityTypes.SKETCHBOOK_PAPER.get()).create((Level)level);
        if (entity != null) {
            Vec3 spawnPos = Vec3.atCenterOf((Vec3i)this.getPos()).relative(this.getDirection(), 0.5);
            entity.moveTo(spawnPos);
            List data = (List)stack.get(OeuvDataComponents.SKETCH_DATA);
            entity.setSketchData(data);
            if (stack.has(OeuvDataComponents.STICKER_LIST)) {
                entity.setStickers((List)stack.get(OeuvDataComponents.STICKER_LIST));
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                entity.setCustomName(stack.getHoverName());
            }
            entity.setFromFrame(this.getPos());
            level.addFreshEntity((Entity)entity);
            this.spawnedEntityUUID = entity.getUUID();
        }
    }

    public void remove(Entity.RemovalReason reason) {
        Entity entity;
        if (!this.level().isClientSide && this.spawnedEntityUUID != null && (entity = ((ServerLevel)this.level()).getEntity(this.spawnedEntityUUID)) != null) {
            entity.discard();
        }
        super.remove(reason);
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)OeuvItems.ANIMATING_ITEM_FRAME.get());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.spawnedEntityUUID != null) {
            compound.putUUID("SpawnedEntity", this.spawnedEntityUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("SpawnedEntity")) {
            this.spawnedEntityUUID = compound.getUUID("SpawnedEntity");
        }
    }
}

