/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.exavior.oeuvre.entity.custom.IllustratorPaperEntity;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.exavior.oeuvre.util.IllustratorPixelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class IllustratorEntity
extends SpellcasterIllager {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState castingAnimationState = new AnimationState();
    public final AnimationState castingWalkAnimationState = new AnimationState();

    public IllustratorEntity(EntityType<? extends SpellcasterIllager> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(2, (Goal)new IllustratorSummonSpellGoal());
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        boolean isMoving = this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
        boolean isCasting = this.isCastingSpell();
        if (isCasting) {
            this.idleAnimationState.stop();
            this.walkAnimationState.stop();
            if (isMoving) {
                this.castingAnimationState.stop();
                this.castingWalkAnimationState.startIfStopped(this.tickCount);
            } else {
                this.castingWalkAnimationState.stop();
                this.castingAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.castingAnimationState.stop();
            this.castingWalkAnimationState.stop();
            if (isMoving) {
                this.idleAnimationState.stop();
                this.walkAnimationState.startIfStopped(this.tickCount);
            } else {
                this.walkAnimationState.stop();
                this.idleAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.EVOKER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.EVOKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.EVOKER_HURT;
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    class IllustratorSummonSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        IllustratorSummonSpellGoal() {
            super((SpellcasterIllager)IllustratorEntity.this);
        }

        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int existingSummons = IllustratorEntity.this.level().getEntitiesOfClass(IllustratorPaperEntity.class, IllustratorEntity.this.getBoundingBox().inflate(32.0)).size();
            return existingSummons < 3;
        }

        protected int getCastingTime() {
            return 60;
        }

        protected int getCastingInterval() {
            return 160;
        }

        protected void performSpellCasting() {
            ServerLevel serverLevel = (ServerLevel)IllustratorEntity.this.level();
            IllustratorPaperEntity paper = (IllustratorPaperEntity)((EntityType)OeuvEntityTypes.ILLUSTRATOR_PAPER.get()).create((Level)serverLevel);
            if (paper != null) {
                Collection<Integer> ids;
                BlockPos pos = IllustratorEntity.this.blockPosition().offset(-2 + IllustratorEntity.this.random.nextInt(5), 1, -2 + IllustratorEntity.this.random.nextInt(5));
                paper.moveTo(pos, 0.0f, 0.0f);
                paper.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                paper.setOwner((LivingEntity)IllustratorEntity.this);
                if (IllustratorEntity.this.getTarget() != null) {
                    paper.setTarget(IllustratorEntity.this.getTarget());
                }
                if (!(ids = IllustratorPixelManager.getBossSummonIDs()).isEmpty()) {
                    ArrayList<Integer> listIds = new ArrayList<Integer>(ids);
                    int randomId = (Integer)listIds.get(IllustratorEntity.this.random.nextInt(listIds.size()));
                    paper.setVariationId(randomId);
                    List<Integer> pixels = IllustratorPixelManager.getVariation(randomId);
                    paper.setSketchData(pixels);
                }
                serverLevel.addFreshEntity((Entity)paper);
            }
        }

        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }
}

