/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.custom;

import java.util.ArrayList;
import java.util.List;
import net.exavior.oeuvre.entity.custom.IllustratorVexEntity;
import net.exavior.oeuvre.network.server.S2CSyncSketchDataPacket;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class IllustratorPaperEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> VARIATION_ID = SynchedEntityData.defineId(IllustratorPaperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final float DEPTH = 0.0325f;
    private static final int MAX_LIFE_TICKS = 600;
    private float pixelWidth = 0.5f;
    private float pixelHeight = 0.5f;
    private int lifeTicks = 0;
    private List<Integer> sketchData = new ArrayList<Integer>();
    private int summonCooldown = 60;
    @Nullable
    private LivingEntity owner;

    public IllustratorPaperEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.refreshDimensions();
        this.xpReward = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean canUse() {
                return super.canUse() && IllustratorPaperEntity.this.getVariationId() != 2 && IllustratorPaperEntity.this.getVariationId() != 3;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && IllustratorPaperEntity.this.getVariationId() != 2 && IllustratorPaperEntity.this.getVariationId() != 3;
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal(this, 1.0, 60, 15.0f){

            public boolean canUse() {
                return super.canUse() && IllustratorPaperEntity.this.getVariationId() == 2;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && IllustratorPaperEntity.this.getVariationId() == 2;
            }
        });
        this.goalSelector.addGoal(2, new Goal(){

            public boolean canUse() {
                return IllustratorPaperEntity.this.getVariationId() == 3 && IllustratorPaperEntity.this.getTarget() != null;
            }

            public void tick() {
                if (--IllustratorPaperEntity.this.summonCooldown <= 0) {
                    IllustratorPaperEntity.this.spawnVex();
                    IllustratorPaperEntity.this.summonCooldown = 200;
                }
            }
        });
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0){

            public boolean canUse() {
                return super.canUse() && IllustratorPaperEntity.this.getVariationId() == 3;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    private void spawnVex() {
        if (this.level().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level();
        IllustratorVexEntity vex = (IllustratorVexEntity)((EntityType)OeuvEntityTypes.ILLUSTRATOR_VEX.get()).create((Level)serverLevel);
        if (vex != null) {
            vex.moveTo(this.getX(), this.getY() + 0.5, this.getZ(), 0.0f, 0.0f);
            if (this.getTarget() != null) {
                vex.setTarget(this.getTarget());
            }
            serverLevel.addFreshEntity((Entity)vex);
            this.playSound(SoundEvents.EVOKER_CAST_SPELL, 1.0f, 1.0f);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack arrowStack = new ItemStack((ItemLike)Items.ARROW);
        Arrow arrow = new Arrow(this.level(), (LivingEntity)this, arrowStack, new ItemStack((ItemLike)Items.BOW));
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - arrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f);
        this.level().addFreshEntity((Entity)arrow);
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
    }

    public void setVariationId(int id) {
        this.entityData.set(VARIATION_ID, (Object)id);
    }

    public int getVariationId() {
        return (Integer)this.entityData.get(VARIATION_ID);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ++this.lifeTicks;
            if (this.lifeTicks >= 600) {
                this.discard();
            }
        }
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        if (this.getDimensions(Pose.STANDING) == null) {
            return super.makeBoundingBox();
        }
        float w = this.pixelWidth;
        float h = this.pixelHeight;
        float d = 0.0325f;
        float yRot = this.getYRot();
        float rad = yRot * ((float)Math.PI / 180);
        float cos = Math.abs(Mth.cos((float)rad));
        float sin = Math.abs(Mth.sin((float)rad));
        float extX = w * cos + d * sin;
        float extZ = w * sin + d * cos;
        Vec3 pos = this.position();
        return new AABB(pos.x - (double)(extX / 2.0f), pos.y, pos.z - (double)(extZ / 2.0f), pos.x + (double)(extX / 2.0f), pos.y + (double)h, pos.z + (double)(extZ / 2.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIATION_ID, (Object)1);
    }

    private void recalculateDimensions() {
        List<Integer> pixels = this.getSketchData();
        if (pixels == null || pixels.isEmpty()) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
            this.refreshDimensions();
            return;
        }
        int gridSize = (int)Math.sqrt(pixels.size());
        if (gridSize == 0) {
            gridSize = 32;
        }
        int minY = gridSize;
        float maxDistFromCenter = 0.0f;
        boolean empty = true;
        float center = (float)(gridSize - 1) / 2.0f;
        for (int i = 0; i < pixels.size() && i < gridSize * gridSize; ++i) {
            float dist;
            int color = pixels.get(i);
            int alpha = color >> 24 & 0xFF;
            if (alpha <= 0) continue;
            empty = false;
            int x = i % gridSize;
            int y = i / gridSize;
            if (y < minY) {
                minY = y;
            }
            if (!((dist = Math.abs((float)x - center)) > maxDistFromCenter)) continue;
            maxDistFromCenter = dist;
        }
        if (empty) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
        } else {
            float relativeWidth = (maxDistFromCenter + 0.5f) * 2.0f / (float)gridSize;
            float relativeHeight = (float)(gridSize - minY) / (float)gridSize;
            this.pixelWidth = Math.max(0.1f, relativeWidth * 2.0f);
            this.pixelHeight = Math.max(0.1f, relativeHeight * 2.0f);
        }
        this.refreshDimensions();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.pixelWidth, (float)this.pixelHeight);
    }

    public void setSketchData(List<Integer> pixels) {
        if (pixels == null) {
            pixels = new ArrayList<Integer>();
        }
        this.sketchData = pixels;
        this.recalculateDimensions();
        if (!this.level().isClientSide()) {
            int[] array = pixels.stream().mapToInt(i -> i).toArray();
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new S2CSyncSketchDataPacket(this.getId(), array), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setSketchDataFromPacket(List<Integer> pixels) {
        this.sketchData = pixels;
        this.recalculateDimensions();
    }

    public List<Integer> getSketchData() {
        return this.sketchData;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        int[] array = this.sketchData.stream().mapToInt(i -> i).toArray();
        compound.putIntArray("SketchDataInts", array);
        compound.putInt("LifeTicks", this.lifeTicks);
        compound.putInt("VariationId", this.getVariationId());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SketchDataInts")) {
            int[] array = compound.getIntArray("SketchDataInts");
            this.sketchData = new ArrayList<Integer>();
            for (int i : array) {
                this.sketchData.add(i);
            }
            this.recalculateDimensions();
        } else if (compound.contains("SketchData")) {
            String[] parts;
            String data = compound.getString("SketchData");
            this.sketchData = new ArrayList<Integer>();
            for (String s : parts = data.split(",")) {
                if (s.isBlank()) continue;
                try {
                    this.sketchData.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.recalculateDimensions();
        }
        if (compound.contains("LifeTicks")) {
            this.lifeTicks = compound.getInt("LifeTicks");
        }
        if (compound.contains("VariationId")) {
            this.setVariationId(compound.getInt("VariationId"));
        }
    }
}

