/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.exavior.oeuvre.util.IllustratorPixelManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class IllustratorVexEntity
extends Monster {
    private static final EntityDataAccessor<String> SKETCH_DATA_SYNC = SynchedEntityData.defineId(IllustratorVexEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final float DEPTH = 0.0325f;
    private static final int MAX_LIFE_TICKS = 600;
    private float pixelWidth = 0.5f;
    private float pixelHeight = 0.5f;
    private int lifeTicks = 0;

    public IllustratorVexEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.refreshDimensions();
        this.xpReward = 0;
        List<Integer> pixels = IllustratorPixelManager.getVariation(4);
        if (!pixels.isEmpty()) {
            this.setSketchData(pixels);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            ++this.lifeTicks;
            if (this.lifeTicks >= 600) {
                this.discard();
            }
        }
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        if (this.getDimensions(Pose.STANDING) == null) {
            return super.makeBoundingBox();
        }
        float w = this.pixelWidth;
        float h = this.pixelHeight;
        float d = 0.0325f;
        float yRot = this.getYRot();
        float rad = yRot * ((float)Math.PI / 180);
        float cos = Math.abs(Mth.cos((float)rad));
        float sin = Math.abs(Mth.sin((float)rad));
        float extX = w * cos + d * sin;
        float extZ = w * sin + d * cos;
        Vec3 pos = this.position();
        return new AABB(pos.x - (double)(extX / 2.0f), pos.y, pos.z - (double)(extZ / 2.0f), pos.x + (double)(extX / 2.0f), pos.y + (double)h, pos.z + (double)(extZ / 2.0f));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SKETCH_DATA_SYNC, (Object)"");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SKETCH_DATA_SYNC.equals(key)) {
            this.recalculateDimensions();
        }
    }

    private void recalculateDimensions() {
        List<Integer> pixels = this.getSketchData();
        if (pixels == null || pixels.isEmpty()) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
            this.refreshDimensions();
            return;
        }
        int minY = 32;
        float maxDistFromCenter = 0.0f;
        boolean empty = true;
        for (int i = 0; i < pixels.size() && i < 1024; ++i) {
            float dist;
            int color = pixels.get(i);
            int alpha = color >> 24 & 0xFF;
            if (alpha <= 0) continue;
            empty = false;
            int x = i % 32;
            int y = i / 32;
            if (y < minY) {
                minY = y;
            }
            if (!((dist = Math.abs((float)x - 15.5f)) > maxDistFromCenter)) continue;
            maxDistFromCenter = dist;
        }
        if (empty) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
        } else {
            float widthInPixels = (maxDistFromCenter + 0.5f) * 2.0f;
            float heightInPixels = 32 - minY;
            this.pixelWidth = Math.max(0.0325f, widthInPixels / 16.0f);
            this.pixelHeight = Math.max(0.5f, heightInPixels / 16.0f);
        }
        this.refreshDimensions();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.pixelWidth, (float)this.pixelHeight);
    }

    public void setSketchData(List<Integer> pixels) {
        if (pixels == null || pixels.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer i : pixels) {
            sb.append(i).append(",");
        }
        this.entityData.set(SKETCH_DATA_SYNC, (Object)sb.toString());
        this.recalculateDimensions();
    }

    public List<Integer> getSketchData() {
        String[] parts;
        String data = (String)this.entityData.get(SKETCH_DATA_SYNC);
        if (data.isEmpty()) {
            return Collections.nCopies(1024, 0);
        }
        ArrayList<Integer> pixels = new ArrayList<Integer>();
        for (String s : parts = data.split(",")) {
            if (s.isBlank()) continue;
            try {
                pixels.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                pixels.add(0);
            }
        }
        return pixels;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("SketchData", (String)this.entityData.get(SKETCH_DATA_SYNC));
        compound.putInt("LifeTicks", this.lifeTicks);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SketchData")) {
            this.entityData.set(SKETCH_DATA_SYNC, (Object)compound.getString("SketchData"));
            this.recalculateDimensions();
        }
        if (compound.contains("LifeTicks")) {
            this.lifeTicks = compound.getInt("LifeTicks");
        }
    }
}

