/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.exavior.oeuvre.network.server.S2CSyncSketchDataPacket;
import net.exavior.oeuvre.registry.OeuvItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SketchBookPaperEntity
extends TamableAnimal
implements RangedAttackMob {
    private static final EntityDataAccessor<ItemStack> STICKER_0 = SynchedEntityData.defineId(SketchBookPaperEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<ItemStack> STICKER_1 = SynchedEntityData.defineId(SketchBookPaperEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<ItemStack> STICKER_2 = SynchedEntityData.defineId(SketchBookPaperEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final float DEPTH = 0.0325f;
    private float pixelWidth = 0.5f;
    private float pixelHeight = 0.5f;
    private static final int MAX_LIFE_TICKS = 600;
    private int lifeTicks = 0;
    private boolean isFrameEntity = false;
    private BlockPos framePos = BlockPos.ZERO;
    private List<Integer> sketchData = new ArrayList<Integer>();
    private final MoveControl groundControl;
    private final MoveControl flightControl;
    private final MoveControl swimControl;
    private final PathNavigation groundNav;
    private final PathNavigation flightNav;
    private final PathNavigation waterNav;
    private static final UUID MELEE_BOOST_UUID = UUID.fromString("1e223344-5566-7788-99aa-bbccddeeff00");
    private static final AttributeModifier MELEE_BOOST = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)"sticker_melee_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    private MeleeAttackGoal meleeGoal;
    private RangedAttackGoal rangedGoal;
    private FollowOwnerGoal followGoal;
    private OwnerHurtByTargetGoal ownerHurtByGoal;
    private OwnerHurtTargetGoal ownerHurtTargetGoal;
    private HurtByTargetGoal hurtByGoal;

    public SketchBookPaperEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.refreshDimensions();
        this.xpReward = 0;
        this.groundControl = new MoveControl((Mob)this);
        this.flightControl = new FlyingMoveControl((Mob)this, 20, true);
        this.swimControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.groundNav = new GroundPathNavigation((Mob)this, level);
        this.flightNav = new FlyingPathNavigation((Mob)this, level);
        this.waterNav = new AmphibiousPathNavigation((Mob)this, level);
        this.moveControl = this.groundControl;
        this.navigation = this.groundNav;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.FLYING_SPEED, 0.6);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STICKER_0, (Object)ItemStack.EMPTY);
        builder.define(STICKER_1, (Object)ItemStack.EMPTY);
        builder.define(STICKER_2, (Object)ItemStack.EMPTY);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && !SketchBookPaperEntity.this.hasAirSticker() && !SketchBookPaperEntity.this.hasWaterSticker() && !SketchBookPaperEntity.this.hasAmphibianSticker();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return SketchBookPaperEntity.this.hasAirSticker() && super.canUse();
            }
        });
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this){

            public boolean canUse() {
                return (SketchBookPaperEntity.this.hasWaterSticker() || SketchBookPaperEntity.this.hasAmphibianSticker()) && super.canUse();
            }
        });
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this){

            public boolean canUse() {
                return SketchBookPaperEntity.this.hasWaterSticker() && !SketchBookPaperEntity.this.hasAmphibianSticker() && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10){

            public boolean canUse() {
                return (SketchBookPaperEntity.this.hasWaterSticker() || SketchBookPaperEntity.this.hasAmphibianSticker()) && super.canUse();
            }
        });
        this.meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean canUse() {
                return super.canUse() && !SketchBookPaperEntity.this.hasBowSticker();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !SketchBookPaperEntity.this.hasBowSticker();
            }
        };
        this.goalSelector.addGoal(2, (Goal)this.meleeGoal);
        this.rangedGoal = new RangedAttackGoal(this, 1.0, 80, 15.0f){

            public boolean canUse() {
                return super.canUse() && SketchBookPaperEntity.this.hasBowSticker();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && SketchBookPaperEntity.this.hasBowSticker();
            }
        };
        this.goalSelector.addGoal(2, (Goal)this.rangedGoal);
        this.followGoal = new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 3.0f);
        this.goalSelector.addGoal(3, (Goal)this.followGoal);
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.ownerHurtByGoal = new OwnerHurtByTargetGoal((TamableAnimal)this);
        this.targetSelector.addGoal(1, (Goal)this.ownerHurtByGoal);
        this.ownerHurtTargetGoal = new OwnerHurtTargetGoal((TamableAnimal)this);
        this.targetSelector.addGoal(2, (Goal)this.ownerHurtTargetGoal);
        this.hurtByGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);
        this.targetSelector.addGoal(3, (Goal)this.hurtByGoal);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.updateAbilities();
            if (!this.isFrameEntity) {
                ++this.lifeTicks;
                if (this.lifeTicks >= 600) {
                    this.discard();
                }
            } else if (this.blockPosition().distSqr((Vec3i)this.framePos) > 1024.0) {
                this.navigation.moveTo((double)this.framePos.getX(), (double)this.framePos.getY(), (double)this.framePos.getZ(), 1.0);
            }
        }
        this.setBoundingBox(this.makeBoundingBox());
    }

    private void updateAbilities() {
        AttributeInstance attackAttr;
        boolean isAir = this.hasAirSticker();
        boolean isWater = this.hasWaterSticker();
        boolean isAmphibian = this.hasAmphibianSticker();
        boolean isNether = this.hasNetherSticker();
        if (isNether) {
            this.clearFire();
        }
        if (isAir) {
            this.setNoGravity(true);
            if (this.moveControl != this.flightControl) {
                this.moveControl = this.flightControl;
            }
            if (this.navigation != this.flightNav) {
                this.navigation = this.flightNav;
            }
        } else if (isWater || isAmphibian) {
            this.setNoGravity(this.isInWater());
            if (this.moveControl != this.swimControl) {
                this.moveControl = this.swimControl;
            }
            if (this.navigation != this.waterNav) {
                this.navigation = this.waterNav;
            }
            if (isWater && !isAmphibian && !this.isInWaterOrBubble() && !this.level().isRaining() && this.tickCount % 20 == 0) {
                this.hurt(this.damageSources().dryOut(), 1.0f);
            }
        } else {
            this.setNoGravity(false);
            if (this.moveControl != this.groundControl) {
                this.moveControl = this.groundControl;
            }
            if (this.navigation != this.groundNav) {
                this.navigation = this.groundNav;
            }
        }
        if ((attackAttr = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            if (this.hasMeleeSticker()) {
                if (!attackAttr.hasModifier(MELEE_BOOST.id())) {
                    attackAttr.addTransientModifier(MELEE_BOOST);
                }
            } else if (attackAttr.hasModifier(MELEE_BOOST.id())) {
                attackAttr.removeModifier(MELEE_BOOST.id());
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack arrowStack = new ItemStack((ItemLike)Items.ARROW);
        Arrow arrow = new Arrow(this.level(), (LivingEntity)this, arrowStack, new ItemStack((ItemLike)Items.BOW));
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - arrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    public boolean hasAirSticker() {
        return this.getStickerInSlot(0).is((Item)OeuvItems.STICKER_AIR.get());
    }

    public boolean hasWaterSticker() {
        return this.getStickerInSlot(0).is((Item)OeuvItems.STICKER_WATER.get());
    }

    public boolean hasNetherSticker() {
        return this.getStickerInSlot(0).is((Item)OeuvItems.STICKER_NETHER.get());
    }

    public boolean hasAmphibianSticker() {
        return this.getStickerInSlot(0).is((Item)OeuvItems.STICKER_AMPHIBIAN.get());
    }

    public boolean hasMeleeSticker() {
        return this.getStickerInSlot(1).is((Item)OeuvItems.STICKER_MELEE.get());
    }

    public boolean hasBowSticker() {
        return this.getStickerInSlot(1).is((Item)OeuvItems.STICKER_BOW.get());
    }

    public ItemStack getStickerInSlot(int slot) {
        if (slot == 0) {
            return (ItemStack)this.entityData.get(STICKER_0);
        }
        if (slot == 1) {
            return (ItemStack)this.entityData.get(STICKER_1);
        }
        if (slot == 2) {
            return (ItemStack)this.entityData.get(STICKER_2);
        }
        return ItemStack.EMPTY;
    }

    public void setStickers(List<ItemStack> stickers) {
        if (stickers.size() > 0) {
            this.entityData.set(STICKER_0, (Object)stickers.get(0));
        }
        if (stickers.size() > 1) {
            this.entityData.set(STICKER_1, (Object)stickers.get(1));
        }
        if (stickers.size() > 2) {
            this.entityData.set(STICKER_2, (Object)stickers.get(2));
        }
    }

    public void setFromFrame(BlockPos pos) {
        this.isFrameEntity = true;
        this.framePos = pos;
        this.setPersistenceRequired();
        this.restrictTo(pos, 32);
        if (this.meleeGoal != null) {
            this.goalSelector.removeGoal((Goal)this.meleeGoal);
        }
        if (this.rangedGoal != null) {
            this.goalSelector.removeGoal((Goal)this.rangedGoal);
        }
        if (this.followGoal != null) {
            this.goalSelector.removeGoal((Goal)this.followGoal);
        }
        if (this.ownerHurtByGoal != null) {
            this.targetSelector.removeGoal((Goal)this.ownerHurtByGoal);
        }
        if (this.ownerHurtTargetGoal != null) {
            this.targetSelector.removeGoal((Goal)this.ownerHurtTargetGoal);
        }
        if (this.hurtByGoal != null) {
            this.targetSelector.removeGoal((Goal)this.hurtByGoal);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        if ((this.hasWaterSticker() || this.hasAmphibianSticker()) && type == NeoForgeMod.WATER_TYPE.value()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean fireImmune() {
        return this.hasNetherSticker() || super.fireImmune();
    }

    public boolean isPushedByFluid() {
        return !this.hasWaterSticker() && !this.hasAmphibianSticker();
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi()) {
            if (this.hasAirSticker()) {
                if (this.isInWater()) {
                    this.moveRelative(0.02f, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
                } else {
                    this.moveRelative(0.1f, travelVector);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
                }
                return;
            }
            if ((this.hasWaterSticker() || this.hasAmphibianSticker()) && this.isInWater()) {
                this.moveRelative(0.1f, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
                if (this.getTarget() == null) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
                }
                return;
            }
        }
        super.travel(travelVector);
    }

    protected AABB makeBoundingBox() {
        if (this.getDimensions(Pose.STANDING) == null) {
            return super.makeBoundingBox();
        }
        float w = this.pixelWidth;
        float h = this.pixelHeight;
        float d = 0.0325f;
        float yRot = this.getYRot();
        float rad = yRot * ((float)Math.PI / 180);
        float cos = Math.abs(Mth.cos((float)rad));
        float sin = Math.abs(Mth.sin((float)rad));
        float extX = w * cos + d * sin;
        float extZ = w * sin + d * cos;
        Vec3 pos = this.position();
        return new AABB(pos.x - (double)(extX / 2.0f), pos.y, pos.z - (double)(extZ / 2.0f), pos.x + (double)(extX / 2.0f), pos.y + (double)h, pos.z + (double)(extZ / 2.0f));
    }

    protected void dropExperience(@Nullable Entity entity) {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public void push(Entity entity) {
        if (!(entity instanceof SketchBookPaperEntity)) {
            return;
        }
        super.push(entity);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
    }

    private void recalculateDimensions() {
        List<Integer> pixels = this.getSketchData();
        if (pixels == null || pixels.isEmpty()) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
            this.refreshDimensions();
            return;
        }
        int gridSize = (int)Math.sqrt(pixels.size());
        if (gridSize == 0) {
            gridSize = 32;
        }
        int minY = gridSize;
        float maxDistFromCenter = 0.0f;
        boolean empty = true;
        float center = (float)(gridSize - 1) / 2.0f;
        for (int i = 0; i < pixels.size() && i < gridSize * gridSize; ++i) {
            float dist;
            int color = pixels.get(i);
            int alpha = color >> 24 & 0xFF;
            if (alpha <= 0) continue;
            empty = false;
            int x = i % gridSize;
            int y = i / gridSize;
            if (y < minY) {
                minY = y;
            }
            if (!((dist = Math.abs((float)x - center)) > maxDistFromCenter)) continue;
            maxDistFromCenter = dist;
        }
        if (empty) {
            this.pixelWidth = 0.5f;
            this.pixelHeight = 0.5f;
        } else {
            float relativeWidth = (maxDistFromCenter + 0.5f) * 2.0f / (float)gridSize;
            float relativeHeight = (float)(gridSize - minY) / (float)gridSize;
            this.pixelWidth = Math.max(1.0f, relativeWidth * 2.0f);
            this.pixelHeight = Math.max(1.0f, relativeHeight * 2.0f);
        }
        this.refreshDimensions();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return EntityDimensions.scalable((float)this.pixelWidth, (float)this.pixelHeight);
    }

    public void setSketchData(List<Integer> pixels) {
        if (pixels == null) {
            pixels = new ArrayList<Integer>();
        }
        this.sketchData = pixels;
        this.recalculateDimensions();
        if (!this.level().isClientSide()) {
            int[] array = pixels.stream().mapToInt(i -> i).toArray();
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new S2CSyncSketchDataPacket(this.getId(), array), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setSketchDataFromPacket(List<Integer> pixels) {
        this.sketchData = pixels;
        this.recalculateDimensions();
    }

    public List<Integer> getSketchData() {
        return this.sketchData;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide() && !this.sketchData.isEmpty()) {
            int[] array = this.sketchData.stream().mapToInt(i -> i).toArray();
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new S2CSyncSketchDataPacket(this.getId(), array), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.hasAirSticker()) {
            super.checkFallDamage(y, onGround, state, pos);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        int[] array = this.sketchData.stream().mapToInt(i -> i).toArray();
        compound.putIntArray("SketchDataInts", array);
        compound.putBoolean("IsFrameEntity", this.isFrameEntity);
        if (this.isFrameEntity) {
            compound.putInt("FrameX", this.framePos.getX());
            compound.putInt("FrameY", this.framePos.getY());
            compound.putInt("FrameZ", this.framePos.getZ());
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            ItemStack s = this.getStickerInSlot(i2);
            if (s.isEmpty()) continue;
            compound.put("Sticker_" + i2, s.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SketchDataInts")) {
            int[] array = compound.getIntArray("SketchDataInts");
            this.sketchData = new ArrayList<Integer>();
            for (int i : array) {
                this.sketchData.add(i);
            }
            this.recalculateDimensions();
        } else if (compound.contains("SketchData")) {
            String[] parts;
            String data = compound.getString("SketchData");
            this.sketchData = new ArrayList<Integer>();
            for (String s : parts = data.split(",")) {
                if (s.isBlank()) continue;
                try {
                    this.sketchData.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.recalculateDimensions();
        }
        if (compound.contains("IsFrameEntity")) {
            this.isFrameEntity = compound.getBoolean("IsFrameEntity");
            if (this.isFrameEntity) {
                this.framePos = new BlockPos(compound.getInt("FrameX"), compound.getInt("FrameY"), compound.getInt("FrameZ"));
                this.setFromFrame(this.framePos);
            }
        }
        if (compound.contains("Sticker_0")) {
            this.entityData.set(STICKER_0, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Sticker_0")).orElse(ItemStack.EMPTY));
        }
        if (compound.contains("Sticker_1")) {
            this.entityData.set(STICKER_1, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Sticker_1")).orElse(ItemStack.EMPTY));
        }
        if (compound.contains("Sticker_2")) {
            this.entityData.set(STICKER_2, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Sticker_2")).orElse(ItemStack.EMPTY));
        }
    }
}

