/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.exavior.oeuvre.entity.animation.IllustratorAnimationDefinitions;
import net.exavior.oeuvre.entity.custom.IllustratorEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IllustratorModel<T extends IllustratorEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)"illutratormodel"), "main");
    private final ModelPart illustrator;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart nose;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart arms_rotation;
    private final ModelPart arms_flipped;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public IllustratorModel(ModelPart root) {
        this.illustrator = root.getChild("illustrator");
        this.head = this.illustrator.getChild("head");
        this.hat = this.illustrator.getChild("hat");
        this.nose = this.head.getChild("nose");
        this.body = this.illustrator.getChild("body");
        this.arms = this.illustrator.getChild("arms");
        this.arms_rotation = this.arms.getChild("arms_rotation");
        this.arms_flipped = this.arms_rotation.getChild("arms_flipped");
        this.left_arm = this.illustrator.getChild("left_arm");
        this.right_arm = this.illustrator.getChild("right_arm");
        this.left_leg = this.illustrator.getChild("left_leg");
        this.right_leg = this.illustrator.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition illustrator = partdefinition.addOrReplaceChild("illustrator", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = illustrator.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(43, 0).addBox(-6.0f, -13.0f, -6.0f, 12.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(54, 9).addBox(4.0f, -7.0f, -6.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(54, 9).addBox(-6.0f, -7.0f, -6.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(56, 10).addBox(-3.0f, -7.0f, -6.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(46, 3).addBox(-6.0f, -7.0f, -3.0f, 12.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = illustrator.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = illustrator.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = illustrator.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.addOrReplaceChild("arms_rotation", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, 0.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 38).addBox(-4.0f, 4.0f, -2.05f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        PartDefinition arms_flipped = arms_rotation.addOrReplaceChild("arms_flipped", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -24.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_arm = illustrator.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = illustrator.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = illustrator.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = illustrator.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch, float ageInTicks) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void setupAnim(IllustratorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        boolean isCasting = entity.isCastingSpell();
        this.arms.visible = !isCasting;
        this.left_arm.visible = isCasting;
        this.right_arm.visible = isCasting;
        this.animate(entity.idleAnimationState, IllustratorAnimationDefinitions.idle, ageInTicks, 1.0f);
        this.animate(entity.walkAnimationState, IllustratorAnimationDefinitions.walk, ageInTicks, 1.0f);
        this.animate(entity.castingAnimationState, IllustratorAnimationDefinitions.casting, ageInTicks, 1.0f);
        this.animate(entity.castingWalkAnimationState, IllustratorAnimationDefinitions.casting_walk, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.illustrator.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.illustrator;
    }
}

