/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Iterator;
import java.util.List;
import net.exavior.oeuvre.entity.custom.AnimatingItemFrameEntity;
import net.exavior.oeuvre.entity.model.AnimatingItemFrameModel;
import net.exavior.oeuvre.gui.renderer.SketchTextureManager;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvItems;
import net.exavior.oeuvre.registry.OeuvModelLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AnimatingItemFrameRenderer
extends EntityRenderer<AnimatingItemFrameEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)"textures/block/animating_item_frame.png");
    private final AnimatingItemFrameModel<AnimatingItemFrameEntity> model;
    private final ItemRenderer itemRenderer;

    public AnimatingItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new AnimatingItemFrameModel(context.bakeLayer(OeuvModelLayers.ANIMATING_ITEM_FRAME_LAYER));
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(AnimatingItemFrameEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ItemStack itemstack;
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.pushPose();
        Direction direction = entity.getDirection();
        Vec3 vec3 = this.getRenderOffset(entity, partialTicks);
        poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
        poseStack.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        if (!entity.isInvisible()) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.0, -1.5, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.model.renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if (!(itemstack = entity.getItem()).isEmpty()) {
            List pixels;
            MapItemSavedData mapdata = MapItem.getSavedData((ItemStack)itemstack, (Level)entity.level());
            poseStack.translate(0.0f, 0.0f, 0.4375f);
            int rotation = mapdata != null ? entity.getRotation() % 4 * 2 : entity.getRotation();
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation * 360.0f / 8.0f));
            boolean renderedSketch = false;
            if (itemstack.getItem() == OeuvItems.SKETCHBOOK_PAPER.get() && (pixels = (List)itemstack.get(OeuvDataComponents.SKETCH_DATA)) != null && !pixels.isEmpty()) {
                ResourceLocation texture;
                boolean hasDrawing = false;
                Iterator iterator = pixels.iterator();
                while (iterator.hasNext()) {
                    int color = (Integer)iterator.next();
                    if (color == 0) continue;
                    hasDrawing = true;
                    break;
                }
                if (hasDrawing && (texture = SketchTextureManager.getTexture(pixels)) != null) {
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    float scale = 1.0f;
                    poseStack.scale(scale, scale, scale);
                    poseStack.translate(0.0f, 0.0f, 0.0f);
                    VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
                    Matrix4f pose = poseStack.last().pose();
                    float s = 0.5f;
                    vertexConsumer.addVertex(pose, -s, s, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                    vertexConsumer.addVertex(pose, s, s, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                    vertexConsumer.addVertex(pose, s, -s, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                    vertexConsumer.addVertex(pose, -s, -s, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                    poseStack.popPose();
                    renderedSketch = true;
                }
            }
            if (!renderedSketch) {
                if (mapdata != null) {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    float f = 0.0078125f;
                    poseStack.scale(f, f, f);
                    poseStack.translate(-64.0f, -64.0f, 0.0f);
                    poseStack.translate(0.0f, 0.0f, -1.0f);
                    Minecraft.getInstance().gameRenderer.getMapRenderer().render(poseStack, buffer, entity.getFramedMapId(itemstack), mapdata, true, packedLight);
                } else {
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                    this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
                }
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(AnimatingItemFrameEntity entity) {
        return TEXTURE;
    }

    public Vec3 getRenderOffset(AnimatingItemFrameEntity entity, float partialTicks) {
        return new Vec3((double)((float)entity.getDirection().getStepX() * 0.3f), -0.25, (double)((float)entity.getDirection().getStepZ() * 0.3f));
    }

    protected boolean shouldShowName(AnimatingItemFrameEntity entity) {
        if (Minecraft.renderNames() && !entity.getItem().isEmpty() && entity.getItem().has(DataComponents.CUSTOM_NAME) && this.entityRenderDispatcher.crosshairPickEntity == entity) {
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
            float f = entity.isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(AnimatingItemFrameEntity entity, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        super.renderNameTag((Entity)entity, entity.getItem().getHoverName(), poseStack, bufferSource, packedLight, partialTick);
    }
}

