/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.exavior.oeuvre.entity.custom.IllustratorPaperEntity;
import net.exavior.oeuvre.entity.model.SketchBookPaperModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class IllustratorPaperRenderer
extends MobRenderer<IllustratorPaperEntity, SketchBookPaperModel<IllustratorPaperEntity>> {
    private static final Map<UUID, ResourceLocation> TEXTURE_CACHE = new HashMap<UUID, ResourceLocation>();
    private static final int MODEL_TEX_SIZE = 64;
    private static final int MODEL_PAPER_SIZE = 32;

    public IllustratorPaperRenderer(EntityRendererProvider.Context context) {
        super(context, new SketchBookPaperModel(context.bakeLayer(SketchBookPaperModel.LAYER_LOCATION)), 0.5f);
    }

    public void render(IllustratorPaperEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderNameTag(IllustratorPaperEntity entity, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
    }

    public ResourceLocation getTextureLocation(IllustratorPaperEntity entity) {
        int y;
        UUID id = entity.getUUID();
        if (TEXTURE_CACHE.containsKey(id)) {
            return TEXTURE_CACHE.get(id);
        }
        List<Integer> pixels = entity.getSketchData();
        NativeImage image = new NativeImage(64, 64, true);
        for (int x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                image.setPixelRGBA(x, y, 0);
            }
        }
        int dataSize = 32;
        if (pixels.size() > 0) {
            dataSize = (int)Math.sqrt(pixels.size());
        }
        for (y = 0; y < 32; ++y) {
            for (int x = 0; x < 32; ++x) {
                int srcY = y * dataSize / 32;
                int srcX = x * dataSize / 32;
                int index = srcY * dataSize + srcX;
                if (index >= pixels.size()) continue;
                int color = pixels.get(index);
                int a = color >> 24 & 0xFF;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                image.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
            }
        }
        DynamicTexture texture = new DynamicTexture(image);
        texture.setFilter(false, false);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)("dynamic_sketch/illustrator_" + id.toString()));
        Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
        TEXTURE_CACHE.put(id, location);
        return location;
    }
}

