/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.exavior.oeuvre.entity.custom.IllustratorVexEntity;
import net.exavior.oeuvre.entity.model.SketchBookPaperModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class IllustratorVexRenderer
extends MobRenderer<IllustratorVexEntity, SketchBookPaperModel<IllustratorVexEntity>> {
    private static final Map<UUID, ResourceLocation> TEXTURE_CACHE = new HashMap<UUID, ResourceLocation>();

    public IllustratorVexRenderer(EntityRendererProvider.Context context) {
        super(context, new SketchBookPaperModel(context.bakeLayer(SketchBookPaperModel.LAYER_LOCATION)), 0.3f);
    }

    public ResourceLocation getTextureLocation(IllustratorVexEntity entity) {
        UUID id = entity.getUUID();
        if (TEXTURE_CACHE.containsKey(id)) {
            return TEXTURE_CACHE.get(id);
        }
        List<Integer> pixels = entity.getSketchData();
        NativeImage image = new NativeImage(64, 64, true);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                image.setPixelRGBA(x, y, 0);
            }
        }
        for (int i = 0; i < pixels.size() && i < 1024; ++i) {
            int x = i % 32;
            int y = i / 32;
            int color = pixels.get(i);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            image.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
        }
        DynamicTexture texture = new DynamicTexture(image);
        texture.setFilter(false, false);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)("dynamic_vex/" + id.toString()));
        Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
        TEXTURE_CACHE.put(id, location);
        return location;
    }
}

