/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.entity.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.exavior.oeuvre.entity.model.SketchBookPaperModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SketchBookPaperRenderer
extends MobRenderer<SketchBookPaperEntity, SketchBookPaperModel<SketchBookPaperEntity>> {
    private static final Map<UUID, ResourceLocation> TEXTURE_CACHE = new HashMap<UUID, ResourceLocation>();

    public SketchBookPaperRenderer(EntityRendererProvider.Context context) {
        super(context, new SketchBookPaperModel(context.bakeLayer(SketchBookPaperModel.LAYER_LOCATION)), 0.5f);
    }

    public void render(SketchBookPaperEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void renderNameTag(SketchBookPaperEntity entity, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
    }

    public ResourceLocation getTextureLocation(SketchBookPaperEntity entity) {
        UUID id = entity.getUUID();
        if (TEXTURE_CACHE.containsKey(id)) {
            return TEXTURE_CACHE.get(id);
        }
        List<Integer> pixels = entity.getSketchData();
        int dataSize = (int)Math.sqrt(pixels.size());
        if (dataSize == 0) {
            dataSize = 32;
        }
        int textureSize = dataSize * 2;
        NativeImage image = new NativeImage(textureSize, textureSize, true);
        for (int x = 0; x < textureSize; ++x) {
            for (int y = 0; y < textureSize; ++y) {
                image.setPixelRGBA(x, y, 0);
            }
        }
        for (int i = 0; i < pixels.size() && i < dataSize * dataSize; ++i) {
            int x = i % dataSize;
            int y = i / dataSize;
            int color = pixels.get(i);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            image.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
        }
        DynamicTexture texture = new DynamicTexture(image);
        texture.setFilter(false, false);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)("dynamic_sketch/" + id.toString()));
        Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
        TEXTURE_CACHE.put(id, location);
        return location;
    }
}

