/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.gui.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.exavior.oeuvre.block.entities.ArtistDeskBlockEntity;
import net.exavior.oeuvre.registry.OeuvBlocks;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvItems;
import net.exavior.oeuvre.registry.OeuvMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ArtistDeskMenu
extends AbstractContainerMenu {
    private final ArtistDeskBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;
    private final Container resultContainer = new SimpleContainer(1);
    private int selectedResolution = 32;

    public ArtistDeskMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(containerId, playerInv, extraData.readBlockPos());
    }

    public ArtistDeskMenu(int containerId, Inventory playerInv, BlockPos pos) {
        super(OeuvMenus.ARTIST_DESK_MENU.get(), containerId);
        this.blockEntity = (ArtistDeskBlockEntity)playerInv.player.level().getBlockEntity(pos);
        this.levelAccess = ContainerLevelAccess.create((Level)playerInv.player.level(), (BlockPos)pos);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 44, 35){

            public void setChanged() {
                super.setChanged();
                ArtistDeskMenu.this.slotsChanged(ArtistDeskMenu.this.resultContainer);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 1, 80, 35){

            public void setChanged() {
                super.setChanged();
                ArtistDeskMenu.this.slotsChanged(ArtistDeskMenu.this.resultContainer);
            }
        });
        this.addSlot(new Slot(this.resultContainer, 0, 116, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                ItemStack slot0 = ArtistDeskMenu.this.blockEntity.itemHandler.getStackInSlot(0);
                ItemStack slot1 = ArtistDeskMenu.this.blockEntity.itemHandler.getStackInSlot(1);
                if (slot1.is((Item)OeuvItems.LIVING_INK.get())) {
                    ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(0, 1, false);
                    ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(1, 1, false);
                } else if (slot0.is((Item)OeuvItems.SKETCHBOOK_PAPER.get())) {
                    if (slot1.is((Item)OeuvItems.SKETCHBOOK_PAPER.get())) {
                        ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(1, 1, false);
                    } else if (slot1.isEmpty()) {
                        ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(0, 1, false);
                    } else {
                        ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(1, 1, false);
                    }
                } else {
                    ArtistDeskMenu.this.blockEntity.itemHandler.extractItem(1, 1, false);
                }
                ArtistDeskMenu.this.slotsChanged(ArtistDeskMenu.this.resultContainer);
                super.onTake(player, stack);
            }
        });
        this.layoutPlayerInventorySlots(playerInv, 8, 84);
        this.slotsChanged(this.resultContainer);
    }

    public void setResolution(int res) {
        this.selectedResolution = res;
        this.updateResult();
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        this.updateResult();
    }

    private void updateResult() {
        if (this.blockEntity.getLevel().isClientSide) {
            return;
        }
        ItemStack slot0 = this.blockEntity.itemHandler.getStackInSlot(0);
        ItemStack slot1 = this.blockEntity.itemHandler.getStackInSlot(1);
        if (slot0.isEmpty() && slot1.isEmpty()) {
            this.resultContainer.setItem(0, ItemStack.EMPTY);
            return;
        }
        if (slot1.is((Item)OeuvItems.LIVING_INK.get())) {
            if (slot0.is(Items.PAPER)) {
                this.resultContainer.setItem(0, new ItemStack((ItemLike)OeuvItems.SKETCHBOOK_PAPER.get()));
                return;
            }
            if (slot0.is(Items.BOOK)) {
                this.resultContainer.setItem(0, new ItemStack((ItemLike)OeuvItems.SKETCHBOOK.get()));
                return;
            }
            if (slot0.is(Items.ITEM_FRAME)) {
                this.resultContainer.setItem(0, new ItemStack((ItemLike)OeuvItems.ANIMATING_ITEM_FRAME.get()));
                return;
            }
        }
        if (slot0.is((Item)OeuvItems.SKETCHBOOK_PAPER.get()) && slot0.has((DataComponentType)OeuvDataComponents.SKETCH_DATA.get())) {
            List sourceData = (List)slot0.get((DataComponentType)OeuvDataComponents.SKETCH_DATA.get());
            int currentRes = (int)Math.sqrt(sourceData.size());
            if (currentRes == 0) {
                currentRes = 32;
            }
            List<Object> newData = currentRes != this.selectedResolution ? this.resizePixelData(sourceData, currentRes, this.selectedResolution) : new ArrayList(sourceData);
            ItemStack result = ItemStack.EMPTY;
            if (slot1.is((Item)OeuvItems.SKETCHBOOK_PAPER.get())) {
                result = new ItemStack((ItemLike)OeuvItems.SKETCHBOOK_PAPER.get());
                result.applyComponents(slot0.getComponents());
            } else if (slot1.isEmpty()) {
                result = slot0.copy();
                result.setCount(1);
            }
            if (!result.isEmpty()) {
                result.set((DataComponentType)OeuvDataComponents.SKETCH_DATA.get(), newData);
                result.set((DataComponentType)OeuvDataComponents.RESOLUTION.get(), (Object)this.selectedResolution);
                this.resultContainer.setItem(0, result);
                return;
            }
        }
        this.resultContainer.setItem(0, ItemStack.EMPTY);
    }

    private List<Integer> resizePixelData(List<Integer> original, int oldSize, int newSize) {
        ArrayList<Integer> newData = new ArrayList<Integer>(Collections.nCopies(newSize * newSize, 0));
        for (int y = 0; y < newSize; ++y) {
            for (int x = 0; x < newSize; ++x) {
                int srcX = x * oldSize / newSize;
                int srcY = y * oldSize / newSize;
                int col = original.get(srcY * oldSize + srcX);
                newData.set(y * newSize + x, col);
            }
        }
        return newData;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 || index == 1 ? !this.moveItemStackTo(itemstack1, 3, 39, false) : index >= 3 && index < 39 && !this.moveItemStackTo(itemstack1, 1, 2, false) && !this.moveItemStackTo(itemstack1, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)OeuvBlocks.ARTIST_DESK_BLOCK.get()));
    }

    private void layoutPlayerInventorySlots(Inventory playerInv, int leftCol, int topRow) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, leftCol + col * 18, topRow + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, leftCol + col * 18, topRow + 58));
        }
    }
}

