/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.gui.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class SketchTextureManager {
    private static final Map<List<Integer>, ResourceLocation> TEXTURE_CACHE = new HashMap<List<Integer>, ResourceLocation>();

    public static ResourceLocation getTexture(List<Integer> pixels) {
        if (TEXTURE_CACHE.containsKey(pixels)) {
            return TEXTURE_CACHE.get(pixels);
        }
        int size = (int)Math.sqrt(pixels.size());
        if (size == 0) {
            size = 32;
        }
        NativeImage image = new NativeImage(size, size, true);
        for (int i = 0; i < pixels.size() && i < size * size; ++i) {
            int x = i % size;
            int y = i / size;
            int color = pixels.get(i);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            image.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
        }
        DynamicTexture texture = new DynamicTexture(image);
        texture.setFilter(false, false);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)("frame_sketch_" + System.nanoTime()));
        Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture);
        TEXTURE_CACHE.put(pixels, location);
        return location;
    }
}

