/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.exavior.oeuvre.gui.menu.ArtistDeskMenu;
import net.exavior.oeuvre.network.client.CTSUpdateResolutionPacket;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ArtistDeskScreen
extends AbstractContainerScreen<ArtistDeskMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)"textures/gui/artist_desk.png");
    private ResolutionSlider resolutionSlider;
    private final int[] RESOLUTIONS = new int[]{16, 32, 64, 128, 256};
    private int currentResIndex = 1;

    public ArtistDeskScreen(ArtistDeskMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.resolutionSlider = new ResolutionSlider(this.leftPos + 180, this.topPos + 30, 80, 20, (Component)Component.literal((String)"Resolution"), 0.25);
        this.addRenderableWidget((GuiEventListener)this.resolutionSlider);
        this.resolutionSlider.visible = false;
    }

    protected void containerTick() {
        super.containerTick();
        ItemStack slot0 = ((ArtistDeskMenu)this.menu).getSlot(0).getItem();
        boolean hasPaper = slot0.is((Item)OeuvItems.SKETCHBOOK_PAPER.get());
        if (hasPaper != this.resolutionSlider.visible) {
            this.resolutionSlider.visible = hasPaper;
            if (hasPaper) {
                int res = (Integer)slot0.getOrDefault((DataComponentType)OeuvDataComponents.RESOLUTION.get(), (Object)32);
                if (!slot0.has((DataComponentType)OeuvDataComponents.RESOLUTION.get()) && slot0.has((DataComponentType)OeuvDataComponents.SKETCH_DATA.get())) {
                    List data = (List)slot0.get((DataComponentType)OeuvDataComponents.SKETCH_DATA.get());
                    res = (int)Math.sqrt(data.size());
                }
                for (int i = 0; i < this.RESOLUTIONS.length; ++i) {
                    if (this.RESOLUTIONS[i] != res) continue;
                    this.currentResIndex = i;
                    this.resolutionSlider.setSliderValue((double)i / (double)(this.RESOLUTIONS.length - 1));
                    break;
                }
            }
        }
    }

    private void updateSliderMessage() {
        int res = this.RESOLUTIONS[this.currentResIndex];
        this.resolutionSlider.setMessage((Component)Component.literal((String)(res + "x" + res)));
    }

    private void onResolutionChanged(int newIndex) {
        if (this.currentResIndex != newIndex) {
            this.currentResIndex = newIndex;
            this.updateSliderMessage();
            int res = this.RESOLUTIONS[this.currentResIndex];
            PacketDistributor.sendToServer((CustomPacketPayload)new CTSUpdateResolutionPacket(res), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.resolutionSlider.visible) {
            guiGraphics.fill(this.leftPos + 175, this.topPos + 20, this.leftPos + 265, this.topPos + 100, -3750202);
            guiGraphics.renderOutline(this.leftPos + 175, this.topPos + 20, 90, 80, -11184811);
            guiGraphics.drawCenteredString(this.font, "Resolution", this.leftPos + 220, this.topPos + 55, -1);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    class ResolutionSlider
    extends AbstractSliderButton {
        public ResolutionSlider(int x, int y, int width, int height, Component message, double value) {
            super(x, y, width, height, message, value);
            this.updateMessage();
        }

        protected void updateMessage() {
            int index = (int)Math.round(this.value * (double)(ArtistDeskScreen.this.RESOLUTIONS.length - 1));
            index = Mth.clamp((int)index, (int)0, (int)(ArtistDeskScreen.this.RESOLUTIONS.length - 1));
            this.setMessage((Component)Component.literal((String)(ArtistDeskScreen.this.RESOLUTIONS[index] + "x" + ArtistDeskScreen.this.RESOLUTIONS[index])));
        }

        protected void applyValue() {
            int newIndex = (int)Math.round(this.value * (double)(ArtistDeskScreen.this.RESOLUTIONS.length - 1));
            this.value = (double)newIndex / (double)(ArtistDeskScreen.this.RESOLUTIONS.length - 1);
            if (newIndex != ArtistDeskScreen.this.currentResIndex) {
                ArtistDeskScreen.this.onResolutionChanged(newIndex);
            }
        }

        public void setSliderValue(double newValue) {
            double oldValue = this.value;
            this.value = newValue;
            if (oldValue != this.value) {
                this.updateMessage();
            }
        }
    }
}

