/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.gui.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.exavior.oeuvre.network.client.CTSSaveSketchPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.network.PacketDistributor;

public class SketchBookScreen
extends Screen {
    private static final float VISUAL_CANVAS_SIZE = 192.0f;
    private static final int ERASER_COLOR = 0;
    private static final ResourceLocation EYEDROPPER_ICON = ResourceLocation.fromNamespaceAndPath((String)"oeuvre", (String)"textures/gui/eyedropper.png");
    private final List<Integer> pixels;
    private final List<List<Integer>> history = new ArrayList<List<Integer>>();
    private final int gridSize;
    private final float baseScale;
    private DynamicTexture texture;
    private ResourceLocation textureLocation;
    private int lastGridX = -1;
    private int lastGridY = -1;
    private Tool currentTool = Tool.BRUSH;
    private boolean isEraserActive = false;
    private int selectedColor = -16777216;
    private float currentHue = 0.0f;
    private int customColor = -65536;
    private int canvasX;
    private int canvasY;
    private int paletteX;
    private int paletteY;
    private int sliderX;
    private int sliderY;
    private int sliderWidth;
    private int sliderHeight;
    private int customBtnX;
    private int customBtnY;
    private int dropperBtnX;
    private int dropperBtnY;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private final int[] PALETTE = new int[]{-16777216, -1, -65536, -16711936, -16776961, -256, -6283024, Short.MIN_VALUE, -7650029, -38476, -16711681, -8355712, -4144960, -8388608, -16744448, -16777088, -80980, -21152, -2847913, -6267080, -10733020, -12901354, -5192482, -6751336, -10496, -47872, -7077677, -16744320};

    public SketchBookScreen(List<Integer> existingData, int resolution) {
        super((Component)Component.literal((String)"Sketchbook"));
        this.gridSize = resolution > 0 ? resolution : 32;
        this.baseScale = 192.0f / (float)this.gridSize;
        this.pixels = existingData == null || existingData.size() != this.gridSize * this.gridSize ? new ArrayList<Integer>(Collections.nCopies(this.gridSize * this.gridSize, 0)) : new ArrayList<Integer>(existingData);
    }

    protected void init() {
        super.init();
        NativeImage image = new NativeImage(this.gridSize, this.gridSize, true);
        this.updateImageFromData(image);
        this.texture = new DynamicTexture(image);
        this.texture.setFilter(false, false);
        this.textureLocation = this.minecraft.getTextureManager().register("sketch_gui_texture", this.texture);
        int canvasSizeInt = 192;
        int totalWidth = canvasSizeInt + 20 + 85;
        this.canvasX = (this.width - totalWidth) / 2;
        this.canvasY = (this.height - canvasSizeInt) / 2;
        this.paletteX = this.canvasX + canvasSizeInt + 20;
        this.paletteY = this.canvasY;
        this.sliderX = this.canvasX;
        this.sliderY = this.canvasY + canvasSizeInt + 10;
        this.sliderWidth = canvasSizeInt;
        this.sliderHeight = 10;
        this.customBtnX = this.sliderX + this.sliderWidth / 2 - 20;
        this.customBtnY = this.sliderY + this.sliderHeight + 5;
        this.dropperBtnX = this.customBtnX + 45;
        this.dropperBtnY = this.customBtnY;
        this.clearWidgets();
    }

    private float getRenderScale() {
        return this.baseScale * this.zoom;
    }

    private float getRenderX() {
        float currentSize = (float)this.gridSize * this.getRenderScale();
        return (float)this.canvasX + 96.0f - currentSize / 2.0f + this.panX;
    }

    private float getRenderY() {
        float currentSize = (float)this.gridSize * this.getRenderScale();
        return (float)this.canvasY + 96.0f - currentSize / 2.0f + this.panY;
    }

    private void saveSnapshot() {
        if (this.history.size() >= 5) {
            this.history.remove(0);
        }
        this.history.add(new ArrayList<Integer>(this.pixels));
    }

    private void undo() {
        if (!this.history.isEmpty()) {
            List<Integer> previousState = this.history.remove(this.history.size() - 1);
            this.pixels.clear();
            this.pixels.addAll(previousState);
            this.updateTexture();
        }
    }

    private void moveCanvas(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        ArrayList<Integer> newPixels = new ArrayList<Integer>(Collections.nCopies(this.gridSize * this.gridSize, 0));
        for (int y = 0; y < this.gridSize; ++y) {
            for (int x = 0; x < this.gridSize; ++x) {
                int oldIndex = y * this.gridSize + x;
                int color = this.pixels.get(oldIndex);
                if (color == 0) continue;
                int newX = x + dx;
                int newY = y + dy;
                if (newX < 0 || newX >= this.gridSize || newY < 0 || newY >= this.gridSize) continue;
                newPixels.set(newY * this.gridSize + newX, color);
            }
        }
        this.pixels.clear();
        this.pixels.addAll(newPixels);
        this.updateTexture();
    }

    private void paintPixel(int gridX, int gridY) {
        int colorToApply;
        if (gridX < 0 || gridX >= this.gridSize || gridY < 0 || gridY >= this.gridSize) {
            return;
        }
        int index = gridY * this.gridSize + gridX;
        int n = colorToApply = this.isEraserActive ? 0 : this.selectedColor;
        if (this.pixels.get(index) != colorToApply) {
            this.pixels.set(index, colorToApply);
            NativeImage image = this.texture.getPixels();
            if (image != null) {
                this.setPixelOnImage(image, gridX, gridY, colorToApply);
            }
        }
    }

    private void floodFill(int startX, int startY) {
        int replacementColor;
        this.saveSnapshot();
        if (startX < 0 || startX >= this.gridSize || startY < 0 || startY >= this.gridSize) {
            return;
        }
        int targetIndex = startY * this.gridSize + startX;
        int targetColor = this.pixels.get(targetIndex);
        int n = replacementColor = this.isEraserActive ? 0 : this.selectedColor;
        if (targetColor == replacementColor) {
            return;
        }
        ArrayList<Integer> stack = new ArrayList<Integer>();
        stack.add(startX | startY << 16);
        while (!stack.isEmpty()) {
            int index;
            int packed = (Integer)stack.remove(stack.size() - 1);
            int x = packed & 0xFFFF;
            int y = packed >> 16 & 0xFFFF;
            if (x < 0 || x >= this.gridSize || y < 0 || y >= this.gridSize || this.pixels.get(index = y * this.gridSize + x) != targetColor) continue;
            this.pixels.set(index, replacementColor);
            stack.add(x + 1 | y << 16);
            stack.add(x - 1 | y << 16);
            stack.add(x | y + 1 << 16);
            stack.add(x | y - 1 << 16);
        }
        this.updateTexture();
    }

    private void paintLine(int x0, int y0, int x1, int y1) {
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            this.paintPixel(x0, y0);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
        this.texture.upload();
    }

    private int hsbToRgb(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private void updateCustomColor() {
        this.customColor = this.hsbToRgb(this.currentHue, 1.0f, 1.0f);
    }

    private void updateImageFromData(NativeImage image) {
        for (int i = 0; i < this.pixels.size(); ++i) {
            int x = i % this.gridSize;
            int y = i / this.gridSize;
            this.setPixelOnImage(image, x, y, this.pixels.get(i));
        }
    }

    private void setPixelOnImage(NativeImage image, int x, int y, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        image.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
    }

    private void updateTexture() {
        NativeImage image = this.texture.getPixels();
        if (image != null) {
            this.updateImageFromData(image);
            this.texture.upload();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            float scrollSpeed = 0.1f;
            this.zoom = Mth.clamp((float)(this.zoom + (float)scrollY * scrollSpeed), (float)0.2f, (float)5.0f);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        float drawScale = this.getRenderScale();
        float drawX = this.getRenderX();
        float drawY = this.getRenderY();
        float drawSize = (float)this.gridSize * drawScale;
        this.texture.bind();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textureLocation);
        guiGraphics.fill((int)drawX, (int)drawY, (int)(drawX + drawSize), (int)(drawY + drawSize), -4144960);
        guiGraphics.blit(this.textureLocation, (int)drawX, (int)drawY, 0, 0.0f, 0.0f, (int)drawSize, (int)drawSize, (int)drawSize, (int)drawSize);
        guiGraphics.renderOutline((int)drawX - 1, (int)drawY - 1, (int)drawSize + 2, (int)drawSize + 2, -16777216);
        for (int i = 0; i < this.sliderWidth; ++i) {
            float hue = (float)i / (float)this.sliderWidth;
            int color = this.hsbToRgb(hue, 1.0f, 1.0f);
            guiGraphics.fill(this.sliderX + i, this.sliderY, this.sliderX + i + 1, this.sliderY + this.sliderHeight, color);
        }
        guiGraphics.renderOutline(this.sliderX - 1, this.sliderY - 1, this.sliderWidth + 2, this.sliderHeight + 2, -16777216);
        int indicatorX = this.sliderX + (int)(this.currentHue * (float)this.sliderWidth);
        guiGraphics.fill(indicatorX - 1, this.sliderY - 2, indicatorX + 1, this.sliderY + this.sliderHeight + 2, -1);
        guiGraphics.fill(this.customBtnX, this.customBtnY, this.customBtnX + 40, this.customBtnY + 20, this.customColor);
        guiGraphics.renderOutline(this.customBtnX, this.customBtnY, 40, 20, -1);
        if (this.selectedColor == this.customColor && !this.isEraserActive) {
            guiGraphics.renderOutline(this.customBtnX - 1, this.customBtnY - 1, 42, 22, -1);
            guiGraphics.renderOutline(this.customBtnX - 2, this.customBtnY - 2, 44, 24, -16777216);
        } else {
            guiGraphics.renderOutline(this.customBtnX, this.customBtnY, 40, 20, -16777216);
        }
        guiGraphics.fill(this.dropperBtnX, this.dropperBtnY, this.dropperBtnX + 20, this.dropperBtnY + 20, -2236963);
        RenderSystem.enableBlend();
        guiGraphics.blit(EYEDROPPER_ICON, this.dropperBtnX + 2, this.dropperBtnY + 2, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
        if (this.currentTool == Tool.EYEDROPPER) {
            guiGraphics.renderOutline(this.dropperBtnX, this.dropperBtnY, 20, 20, -65536);
        } else {
            guiGraphics.renderOutline(this.dropperBtnX, this.dropperBtnY, 20, 20, -16777216);
        }
        int toolX = this.paletteX;
        int toolY = this.paletteY;
        this.renderToolButton(guiGraphics, toolX, toolY, "Brush", this.currentTool == Tool.BRUSH, -12303105);
        this.renderToolButton(guiGraphics, toolX + 45, toolY, "Bucket", this.currentTool == Tool.BUCKET, -12303105);
        this.renderToolButton(guiGraphics, toolX, toolY += 25, "Erase", this.isEraserActive, -65536);
        this.renderToolButton(guiGraphics, toolX + 45, toolY, "Move", this.currentTool == Tool.MOVE, -12303105);
        guiGraphics.fill(toolX, toolY += 25, toolX + 40, toolY + 20, -2236963);
        guiGraphics.drawCenteredString(this.font, "Undo", toolX + 20, toolY + 6, this.history.isEmpty() ? -5592406 : -1);
        guiGraphics.renderOutline(toolX, toolY, 40, 20, -16777216);
        guiGraphics.fill(toolX + 45, toolY, toolX + 85, toolY + 20, -2236963);
        guiGraphics.drawCenteredString(this.font, "Clear", toolX + 65, toolY + 6, -1);
        guiGraphics.renderOutline(toolX + 45, toolY, 40, 20, -16777216);
        toolY += 30;
        int colorSize = 18;
        int col = 0;
        int rowX = toolX;
        for (int c : this.PALETTE) {
            guiGraphics.fill(rowX, toolY, rowX + colorSize, toolY + colorSize, c);
            if (!this.isEraserActive && c == this.selectedColor) {
                guiGraphics.renderOutline(rowX - 1, toolY - 1, colorSize + 2, colorSize + 2, -1);
                guiGraphics.renderOutline(rowX - 2, toolY - 2, colorSize + 4, colorSize + 4, -16777216);
            } else {
                guiGraphics.renderOutline(rowX, toolY, colorSize, colorSize, -16777216);
            }
            if (++col % 4 == 0) {
                rowX = toolX;
                toolY += colorSize + 4;
                continue;
            }
            rowX += colorSize + 4;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderToolButton(GuiGraphics guiGraphics, int x, int y, String text, boolean isActive, int activeColor) {
        guiGraphics.fill(x, y, x + 40, y + 20, -2236963);
        guiGraphics.drawCenteredString(this.font, text, x + 20, y + 6, -1);
        if (isActive) {
            guiGraphics.renderOutline(x, y, 40, 20, activeColor);
        } else {
            guiGraphics.renderOutline(x, y, 40, 20, -16777216);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float drawX = this.getRenderX();
        float drawY = this.getRenderY();
        float drawScale = this.getRenderScale();
        float drawSize = (float)this.gridSize * drawScale;
        if (mouseX >= (double)drawX && mouseX < (double)(drawX + drawSize) && mouseY >= (double)drawY && mouseY < (double)(drawY + drawSize) && button == 0) {
            int gridX = (int)((mouseX - (double)drawX) / (double)drawScale);
            int gridY = (int)((mouseY - (double)drawY) / (double)drawScale);
            if (this.currentTool == Tool.EYEDROPPER) {
                int index = gridY * this.gridSize + gridX;
                int picked = this.pixels.get(index);
                if (picked != 0) {
                    this.selectedColor = picked;
                    this.customColor = picked;
                    this.isEraserActive = false;
                    this.currentTool = Tool.BRUSH;
                }
                return true;
            }
            if (this.currentTool == Tool.MOVE) {
                this.saveSnapshot();
                this.lastGridX = gridX;
                this.lastGridY = gridY;
            } else if (this.currentTool == Tool.BUCKET) {
                this.floodFill(gridX, gridY);
            } else {
                this.saveSnapshot();
                this.paintPixel(gridX, gridY);
                this.texture.upload();
                this.lastGridX = gridX;
                this.lastGridY = gridY;
            }
            return true;
        }
        if (mouseX >= (double)this.sliderX && mouseX < (double)(this.sliderX + this.sliderWidth) && mouseY >= (double)this.sliderY && mouseY < (double)(this.sliderY + this.sliderHeight)) {
            float hue = (float)(mouseX - (double)this.sliderX) / (float)this.sliderWidth;
            this.currentHue = Mth.clamp((float)hue, (float)0.0f, (float)1.0f);
            this.updateCustomColor();
            return true;
        }
        if (mouseX >= (double)this.customBtnX && mouseX < (double)(this.customBtnX + 40) && mouseY >= (double)this.customBtnY && mouseY < (double)(this.customBtnY + 20)) {
            this.selectedColor = this.customColor;
            this.isEraserActive = false;
            if (this.currentTool == Tool.EYEDROPPER) {
                this.currentTool = Tool.BRUSH;
            }
            return true;
        }
        if (mouseX >= (double)this.dropperBtnX && mouseX < (double)(this.dropperBtnX + 20) && mouseY >= (double)this.dropperBtnY && mouseY < (double)(this.dropperBtnY + 20)) {
            this.currentTool = Tool.EYEDROPPER;
            this.isEraserActive = false;
            return true;
        }
        int toolX = this.paletteX;
        int toolY = this.paletteY;
        if (mouseY >= (double)toolY && mouseY < (double)(toolY + 20)) {
            if (mouseX >= (double)toolX && mouseX < (double)(toolX + 40)) {
                this.currentTool = Tool.BRUSH;
                return true;
            }
            if (mouseX >= (double)(toolX + 45) && mouseX < (double)(toolX + 85)) {
                this.currentTool = Tool.BUCKET;
                return true;
            }
        }
        if (mouseY >= (double)(toolY += 25) && mouseY < (double)(toolY + 20)) {
            if (mouseX >= (double)toolX && mouseX < (double)(toolX + 40)) {
                this.isEraserActive = !this.isEraserActive;
                return true;
            }
            if (mouseX >= (double)(toolX + 45) && mouseX < (double)(toolX + 85)) {
                this.currentTool = Tool.MOVE;
                return true;
            }
        }
        if (mouseY >= (double)(toolY += 25) && mouseY < (double)(toolY + 20)) {
            if (mouseX >= (double)toolX && mouseX < (double)(toolX + 40)) {
                this.undo();
                return true;
            }
            if (mouseX >= (double)(toolX + 45) && mouseX < (double)(toolX + 85)) {
                this.saveSnapshot();
                Collections.fill(this.pixels, 0);
                this.updateTexture();
                return true;
            }
        }
        toolY += 30;
        int colorSize = 18;
        int col = 0;
        int rowX = toolX;
        for (int c : this.PALETTE) {
            if (mouseX >= (double)rowX && mouseX < (double)(rowX + colorSize) && mouseY >= (double)toolY && mouseY < (double)(toolY + colorSize)) {
                this.selectedColor = c;
                this.isEraserActive = false;
                if (this.currentTool == Tool.MOVE || this.currentTool == Tool.EYEDROPPER) {
                    this.currentTool = Tool.BRUSH;
                }
                return true;
            }
            if (++col % 4 == 0) {
                rowX = toolX;
                toolY += colorSize + 4;
                continue;
            }
            rowX += colorSize + 4;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 1) {
            this.panX += (float)dragX;
            this.panY += (float)dragY;
            return true;
        }
        if (mouseX >= (double)this.sliderX && mouseX < (double)(this.sliderX + this.sliderWidth) && mouseY >= (double)this.sliderY && mouseY < (double)(this.sliderY + this.sliderHeight)) {
            float hue = (float)(mouseX - (double)this.sliderX) / (float)this.sliderWidth;
            this.currentHue = Mth.clamp((float)hue, (float)0.0f, (float)1.0f);
            this.updateCustomColor();
            return true;
        }
        float drawX = this.getRenderX();
        float drawY = this.getRenderY();
        float drawScale = this.getRenderScale();
        float drawSize = (float)this.gridSize * drawScale;
        if (button == 0 && mouseX >= (double)drawX && mouseX < (double)(drawX + drawSize) && mouseY >= (double)drawY && mouseY < (double)(drawY + drawSize)) {
            int gridX = (int)((mouseX - (double)drawX) / (double)drawScale);
            int gridY = (int)((mouseY - (double)drawY) / (double)drawScale);
            if (this.currentTool == Tool.MOVE) {
                if (this.lastGridX != -1 && this.lastGridY != -1) {
                    int dx = gridX - this.lastGridX;
                    int dy = gridY - this.lastGridY;
                    if (dx != 0 || dy != 0) {
                        this.moveCanvas(dx, dy);
                        this.lastGridX = gridX;
                        this.lastGridY = gridY;
                    }
                } else {
                    this.lastGridX = gridX;
                    this.lastGridY = gridY;
                }
            } else if (this.currentTool == Tool.BRUSH) {
                if (this.lastGridX != -1 && this.lastGridY != -1) {
                    this.paintLine(this.lastGridX, this.lastGridY, gridX, gridY);
                } else {
                    this.paintPixel(gridX, gridY);
                    this.texture.upload();
                }
                this.lastGridX = gridX;
                this.lastGridY = gridY;
            }
            return true;
        }
        this.lastGridX = -1;
        this.lastGridY = -1;
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.lastGridX = -1;
        this.lastGridY = -1;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new CTSSaveSketchPacket(this.pixels), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static enum Tool {
        BRUSH,
        BUCKET,
        MOVE,
        EYEDROPPER;

    }
}

