/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.item;

import net.exavior.oeuvre.entity.custom.AnimatingItemFrameEntity;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class AnimatingItemFrameItem
extends HangingEntityItem {
    public AnimatingItemFrameItem(Item.Properties properties) {
        super(OeuvEntityTypes.ANIMATING_ITEM_FRAME.get(), properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockPos relativePos = blockpos.relative(direction);
        Player player = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        if (player != null && !this.mayPlace(player, direction, itemstack, relativePos)) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        AnimatingItemFrameEntity entity = new AnimatingItemFrameEntity(level, relativePos, direction);
        if (entity.survives()) {
            if (!level.isClientSide) {
                entity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                level.addFreshEntity((Entity)entity);
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction direction, ItemStack itemStack, BlockPos pos) {
        return !player.level().isOutsideBuildHeight(pos) && player.mayUseItemAt(pos, direction, itemStack);
    }
}

