/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.exavior.oeuvre.item.SketchBookPaperItem;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SketchBookItem
extends Item {
    public SketchBookItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public boolean overrideOtherStackedOnMe(ItemStack bookStack, ItemStack cursorStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        Optional<ItemStack> removed;
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (cursorStack.getItem() instanceof SketchBookPaperItem) {
            if (this.addPaper(bookStack, cursorStack)) {
                this.playInsertSound(player);
                return true;
            }
        } else if (cursorStack.isEmpty() && (removed = this.removePaper(bookStack)).isPresent()) {
            access.set(removed.get());
            this.playRemoveSound(player);
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack bookStack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotStack = slot.getItem();
        if (slotStack.getItem() instanceof SketchBookPaperItem && this.addPaper(bookStack, slotStack)) {
            this.playInsertSound(player);
            return true;
        }
        return false;
    }

    private boolean addPaper(ItemStack book, ItemStack paperSource) {
        ArrayList<ItemStack> papers = new ArrayList<ItemStack>((Collection)book.getOrDefault(OeuvDataComponents.STORED_PAPERS, List.of()));
        if (papers.size() >= 5) {
            return false;
        }
        ItemStack toAdd = paperSource.split(1);
        if (!toAdd.isEmpty()) {
            papers.add(toAdd);
            book.set(OeuvDataComponents.STORED_PAPERS, papers);
            return true;
        }
        return false;
    }

    private Optional<ItemStack> removePaper(ItemStack book) {
        ArrayList papers = new ArrayList((Collection)book.getOrDefault(OeuvDataComponents.STORED_PAPERS, List.of()));
        if (!papers.isEmpty()) {
            ItemStack removed = (ItemStack)papers.remove(papers.size() - 1);
            book.set(OeuvDataComponents.STORED_PAPERS, papers);
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    private void playInsertSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    private void playRemoveSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack bookStack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)bookStack);
        }
        if (level.isClientSide) return InteractionResultHolder.success((Object)bookStack);
        List papers = (List)bookStack.getOrDefault(OeuvDataComponents.STORED_PAPERS, List.of());
        if (papers.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"Sketchbook is empty!").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.success((Object)bookStack);
        }
        Random rand = new Random();
        ItemStack randomPaper = (ItemStack)papers.get(rand.nextInt(papers.size()));
        boolean isBlank = true;
        if (randomPaper.has(OeuvDataComponents.SKETCH_DATA)) {
            List pixels = (List)randomPaper.get(OeuvDataComponents.SKETCH_DATA);
            Iterator iterator = pixels.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                int alpha = color >> 24 & 0xFF;
                if (alpha <= 0) continue;
                isBlank = false;
                break;
            }
        }
        if (isBlank) {
            player.displayClientMessage((Component)Component.literal((String)"The selected paper is blank!").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)bookStack);
        }
        if (!this.consumePaper(player)) {
            player.displayClientMessage((Component)Component.literal((String)"You need Paper to summon a drawing!").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)bookStack);
        }
        SketchBookPaperEntity entity = (SketchBookPaperEntity)((EntityType)OeuvEntityTypes.SKETCHBOOK_PAPER.get()).create(level);
        if (entity == null) return InteractionResultHolder.success((Object)bookStack);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound(null, player.blockPosition(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.8f, 1.3f);
        }
        entity.setPos(player.getX(), player.getY(), player.getZ());
        entity.tame(player);
        if (randomPaper.has(OeuvDataComponents.SKETCH_DATA)) {
            entity.setSketchData((List)randomPaper.get(OeuvDataComponents.SKETCH_DATA));
        }
        if (randomPaper.has(OeuvDataComponents.STICKER_LIST)) {
            entity.setStickers((List)randomPaper.get(OeuvDataComponents.STICKER_LIST));
        }
        entity.setCustomName(randomPaper.getHoverName());
        level.addFreshEntity((Entity)entity);
        player.getCooldowns().addCooldown((Item)this, 20);
        return InteractionResultHolder.success((Object)bookStack);
    }

    private boolean consumePaper(Player player) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        if (player.getMainHandItem().is(Items.PAPER)) {
            player.getMainHandItem().shrink(1);
            return true;
        }
        if (player.getOffhandItem().is(Items.PAPER)) {
            player.getOffhandItem().shrink(1);
            return true;
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is(Items.PAPER)) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        List papers = (List)stack.getOrDefault(OeuvDataComponents.STORED_PAPERS, List.of());
        tooltipComponents.add((Component)Component.literal((String)("Stored Papers: " + papers.size() + "/5")).withStyle(ChatFormatting.GRAY));
    }
}

