/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.exavior.oeuvre.gui.screen.SketchBookScreen;
import net.exavior.oeuvre.gui.tooltip.SketchTooltip;
import net.exavior.oeuvre.item.StickerItem;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvItems;
import net.exavior.oeuvre.registry.OeuvTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SketchBookPaperItem
extends Item {
    public SketchBookPaperItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            ItemStack stack = player.getItemInHand(usedHand);
            List data = (List)stack.get(OeuvDataComponents.SKETCH_DATA);
            int resolution = (Integer)stack.getOrDefault(OeuvDataComponents.RESOLUTION, (Object)32);
            if (data != null && !data.isEmpty()) {
                resolution = (int)Math.sqrt(data.size());
            }
            Minecraft.getInstance().setScreen((Screen)new SketchBookScreen(data, resolution));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    public boolean overrideOtherStackedOnMe(ItemStack paperStack, ItemStack cursorStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        Optional<ItemStack> removed;
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (cursorStack.getItem() instanceof StickerItem) {
            ItemStack returned = this.addOrSwapSticker(paperStack, cursorStack);
            if (returned != null) {
                this.playInsertSound(player);
                if (!returned.isEmpty()) {
                    if (cursorStack.isEmpty()) {
                        access.set(returned);
                    } else if (!player.addItem(returned)) {
                        player.drop(returned, false);
                    }
                }
                return true;
            }
        } else if (cursorStack.isEmpty() && (removed = this.removeLastSticker(paperStack)).isPresent()) {
            this.playRemoveSound(player);
            access.set(removed.get());
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack paperStack, Slot slot, ClickAction action, Player player) {
        ItemStack returned;
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack slotStack = slot.getItem();
        if (slotStack.getItem() instanceof StickerItem && (returned = this.addOrSwapSticker(paperStack, slotStack)) != null) {
            this.playInsertSound(player);
            if (!returned.isEmpty()) {
                if (slotStack.isEmpty()) {
                    slot.set(returned);
                } else if (!player.addItem(returned)) {
                    player.drop(returned, false);
                }
            }
            return true;
        }
        return false;
    }

    private ItemStack addOrSwapSticker(ItemStack paper, ItemStack stickerSource) {
        ArrayList<ItemStack> current = new ArrayList<ItemStack>((Collection)paper.getOrDefault(OeuvDataComponents.STICKER_LIST, new ArrayList()));
        while (current.size() < 3) {
            current.add(ItemStack.EMPTY);
        }
        ItemStack toAdd = stickerSource.split(1);
        ItemStack toReturn = ItemStack.EMPTY;
        int targetSlot = -1;
        if (toAdd.is(OeuvTags.HABITAT_STICKERS) || toAdd.is((Item)OeuvItems.STICKER_AIR.get()) || toAdd.is((Item)OeuvItems.STICKER_WATER.get()) || toAdd.is((Item)OeuvItems.STICKER_NETHER.get()) || toAdd.is((Item)OeuvItems.STICKER_AMPHIBIAN.get())) {
            targetSlot = 0;
        } else if (toAdd.is(OeuvTags.ATTACK_STICKERS) || toAdd.is((Item)OeuvItems.STICKER_MELEE.get()) || toAdd.is((Item)OeuvItems.STICKER_BOW.get())) {
            targetSlot = 1;
        }
        if (targetSlot != -1) {
            ItemStack existing = (ItemStack)current.get(targetSlot);
            if (!existing.isEmpty()) {
                toReturn = existing;
            }
            current.set(targetSlot, toAdd);
            paper.set(OeuvDataComponents.STICKER_LIST, current);
            return toReturn;
        }
        stickerSource.grow(1);
        return null;
    }

    private Optional<ItemStack> removeLastSticker(ItemStack paper) {
        ArrayList<ItemStack> current = new ArrayList<ItemStack>((Collection)paper.getOrDefault(OeuvDataComponents.STICKER_LIST, new ArrayList()));
        for (int i = current.size() - 1; i >= 0; --i) {
            if (((ItemStack)current.get(i)).isEmpty()) continue;
            ItemStack removed = (ItemStack)current.get(i);
            current.set(i, ItemStack.EMPTY);
            paper.set(OeuvDataComponents.STICKER_LIST, current);
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    private void playInsertSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    private void playRemoveSound(Player player) {
        player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(OeuvDataComponents.SKETCH_DATA)) {
            List data = (List)stack.get(OeuvDataComponents.SKETCH_DATA);
            return Optional.of(new SketchTooltip(data));
        }
        return Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List stickers = (List)stack.getOrDefault(OeuvDataComponents.STICKER_LIST, List.of());
        boolean hasStickers = false;
        for (ItemStack sticker : stickers) {
            if (sticker.isEmpty()) continue;
            if (!hasStickers) {
                tooltipComponents.add((Component)Component.literal((String)"Applied Stickers:").withStyle(ChatFormatting.GRAY));
                hasStickers = true;
            }
            tooltipComponents.add((Component)Component.literal((String)"- ").append(sticker.getHoverName()).withStyle(ChatFormatting.BLUE));
        }
        if (!hasStickers) {
            tooltipComponents.add((Component)Component.literal((String)"Right-click with a Sticker to apply").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

