/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.network;

import java.util.ArrayList;
import net.exavior.oeuvre.entity.custom.IllustratorPaperEntity;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.exavior.oeuvre.network.server.S2CSyncSketchDataPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OeuvClientHandler {
    private static final OeuvClientHandler INSTANCE = new OeuvClientHandler();

    public static OeuvClientHandler getInstance() {
        return INSTANCE;
    }

    public void handleSyncSketchData(S2CSyncSketchDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(packet.entityId());
            ArrayList<Integer> listData = new ArrayList<Integer>(packet.pixels().length);
            for (int i : packet.pixels()) {
                listData.add(i);
            }
            if (entity instanceof SketchBookPaperEntity) {
                SketchBookPaperEntity paper = (SketchBookPaperEntity)entity;
                paper.setSketchDataFromPacket(listData);
            } else if (entity instanceof IllustratorPaperEntity) {
                IllustratorPaperEntity illustratorPaper = (IllustratorPaperEntity)entity;
                illustratorPaper.setSketchDataFromPacket(listData);
            }
        });
    }
}

